<?php
/**
 * Instagram section
 *
 * This is the template for the content of instagram section
 *
 * @package Theme Palace
 * @subpackage Biopexel
 * @since Biopexel 1.0.0
 */
if ( ! function_exists( 'biopexel_add_instagram_section' ) ) :
    /**
    * Add instagram section
    *
    *@since Biopexel 1.0.0
    */
    function biopexel_add_instagram_section() {
        $options = biopexel_get_theme_options();

        // Check if instagram is enabled on frontpage
        $instagram_enable = apply_filters( 'biopexel_section_status', true, 'instagram_section_enable' );

        if ( true !== $instagram_enable ) {
            return false;
        }
        // Render instagram section now.
        biopexel_render_instagram_section();
    }
endif;

if ( ! function_exists( 'biopexel_render_instagram_section' ) ) :
  /**
   * Start instagram section
   *
   * @return string instagram content
   * @since Biopexel 1.0.0
   *
   */
   function biopexel_render_instagram_section() {
        $options = biopexel_get_theme_options(); 
        $active_plugins = (array) get_option( 'active_plugins', array() );
        if (!in_array( 'instagram-feed/instagram-feed.php', $active_plugins ) ) {
            return;
        } ?>

        <div id="biopexel_instagram_section" class="relative page-section same-background">
          <div class="wrapper">
            <?php if ( is_customize_preview()):
              biopexel_section_tooltip( 'biopexel_instagram_section' );
            endif; ?>
            <div class="section-header">
              <h2 class="section-title"><?php echo esc_html($options['instagram_section_title']); ?></h2>
            </div><!-- .section-header -->

            <?php echo do_shortcode( wp_kses_post( $options['instagram_section_shortcode'] ) ); ?>
          </div><!-- .wrapper -->
        </div><!-- #instagram-section -->
    <?php
    }
endif; ?>
