<?php
/**
 * Header Content section
 *
 * This is the template for the content of header content section
 *
 * @package Theme Palace
 * @subpackage Fairtimes Pro
 * @since Fairtimes Pro 1.0.0
 */
if ( ! function_exists( 'biopexel_add_header_content_section' ) ) :
    /**
    * Add header content section
    *
    *@since Fairtimes Pro 1.0.0
    */
    function biopexel_add_header_content_section() {
        $options = biopexel_get_theme_options();
        // Check if header content is enabled on frontpage
        $header_content_enable = apply_filters( 'biopexel_section_status', true, 'header_content_section_enable' );

        if ( true !== $header_content_enable ) {
            return false;
        }
        // Get header content section details
        $section_details = array();
        $section_details = apply_filters( 'biopexel_filter_header_content_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render header content section now.
        biopexel_render_header_content_section( $section_details );
    }
endif;

if ( ! function_exists( 'biopexel_get_header_content_section_details' ) ) :
    /**
    * header content section details.
    *
    * @since Fairtimes Pro 1.0.0
    * @param array $input header content section details.
    */
    function biopexel_get_header_content_section_details( $input ) {
        $options = biopexel_get_theme_options();

        $content = array();
        $post_id = ! empty( $options['header_content_content_post'] ) ? $options['header_content_content_post'] : '';
        $args = array(
            'post_type'         => 'post',
            'p'                 => $post_id,
            'posts_per_page'    => 1,
        );

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = biopexel_trim_content( 50 );
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'large' ) : get_template_directory_uri().'/assets/uploads/no-featured-image-600x450.jpg';

                    // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// header content section content details.
add_filter( 'biopexel_filter_header_content_section_details', 'biopexel_get_header_content_section_details' );


if ( ! function_exists( 'biopexel_render_header_content_section' ) ) :
  /**
   * Start header content section
   *
   * @return string header content content
   * @since Fairtimes Pro 1.0.0
   *
   */
   function biopexel_render_header_content_section( $content_details = array() ) {
        $options = biopexel_get_theme_options();
        
        if ( empty( $content_details ) ) {
            return;
        } ?>

        <?php $content = $content_details[0]; ?>

        <div id="biopexel_header_content_section" class="header-content">
            <div class="section-header">
            <?php if ( is_customize_preview()):
                biopexel_section_tooltip( 'header-content-class' );
            endif; ?>
                <h2 class="section-title"><?php echo esc_html($content['title']); ?></h2>
            </div><!-- .section-header -->
            <img src="<?php echo esc_url( $content['image'] ); ?>" alt="header-image">
        </div><!-- #biopexel_header_content_section -->

    <?php
    }    
endif;
