<?php
/**
 * Call To Action section
 *
 * This is the template for the content of Call To Action section
 *
 * @package Theme Palace
 * @subpackage Biopexel
 * @since Biopexel 1.0.0
 */
if ( ! function_exists( 'biopexel_add_cta_section' ) ) :
    /**
    * Add Call To Action section
    *
    *@since Biopexel 1.0.0
    */
    function biopexel_add_cta_section() {
        $options = biopexel_get_theme_options();
        
        // Check if Call To Action is enabled on frontpage
        $cta_enable = apply_filters( 'biopexel_section_status', true, 'cta_section_enable' );

        if ( true !== $cta_enable ) {
            return false;
        }

        // Get Call To Action section details
        $section_details = array();
        $section_details = apply_filters( 'biopexel_filter_cta_section_details', $section_details );
        if ( empty( $section_details ) ) {
            return;
        }

        // Render Call To Action section now.
        biopexel_render_cta_section( $section_details[0] );
    }
endif;

if ( ! function_exists( 'biopexel_get_cta_section_details' ) ) :
    /**
    * Call To Action section details.
    *
    * @since Biopexel 1.0.0
    * @param array $input Call To Action section details.
    */
    function biopexel_get_cta_section_details( $input ) {
        $options = biopexel_get_theme_options();

        $content = array();
        $page_id = ! empty( $options['cta_content_page'] ) ? $options['cta_content_page'] : '';
        $args = array(
            'post_type'             => 'page',
            'posts_per_page'        => 1,
            'p'                     => $page_id,
            'ignore_sticky_posts'   => true,
        );

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = biopexel_trim_content( absint($options['cta_excerpt_length']) );
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri().'/assets/uploads/no-featured-image-600x450.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;

// Call To Action section content details.
add_filter( 'biopexel_filter_cta_section_details', 'biopexel_get_cta_section_details' );


if ( ! function_exists( 'biopexel_render_cta_section' ) ) :
  /**
   * Start Call To Action section
   *
   * @return string Call To Action content
   * @since Biopexel 1.0.0
   *
   */
   function biopexel_render_cta_section( $content_details = array() ) {
        $options    = biopexel_get_theme_options();
        $btn_label  = $options['cta_read_more'];

        if ( empty( $content_details ) ) {
            return;
        } ?>
            <div id="biopexel_cta_section" class="relative page-section same-background">
                <div class="wrapper">
                    <?php if ( is_customize_preview()):
                        biopexel_section_tooltip( 'biopexel_cta_section' );
                    endif; ?>
                   <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $options['cta_sub_title'] ); ?></h2>
                    </div><!-- .section-header -->
                    <div class="section-content">
                        <article>
                            <div class="entry-container">
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content_details['url'] ); ?>"><?php echo esc_html($content_details['title']); ?></a></h2>
                                </header><!-- .entry-header -->

                                <div class="entry-content">
                                    <p><?php echo wp_kses_post($content_details['excerpt']); ?></p>
                                </div><!-- .entry-content -->

                                <div class="read-more">
                                    <a href="<?php echo esc_url( $content_details['url'] ); ?>" class="btn"><?php echo esc_html($btn_label); ?></a>
                                </div><!-- .read-more -->
                            </div><!-- .entry-container -->
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content_details['image'] ); ?>');">
                            </div>
                        </article>
                    </div>
                </div><!-- .wrapper -->
            </div><!-- #blogmax_cta_section -->

    <?php }
endif;