<?php
/**
 * Counter section
 *
 * This is the template for the content of counter section
 *
 * @package Theme Palace
 * @subpackage Biopexel
 * @since Biopexel 1.0.0
 */
if ( ! function_exists( 'biopexel_add_counter_section' ) ) :
    /**
    * Add counter section
    *
    *@since Biopexel 1.0.0
    */
    function biopexel_add_counter_section() {
        $options = biopexel_get_theme_options();
        // Check if counter is enabled on frontpage
        $counter_enable = apply_filters( 'biopexel_section_status', true, 'counter_section_enable' );

        if ( true !== $counter_enable ) {
            return false;
        }

        // Render counter section now.
        biopexel_render_counter_section();
    }
endif;

if ( ! function_exists( 'biopexel_render_counter_section' ) ) :
  /**
   * Start counter section
   *
   * @return string counter content
   * @since Biopexel 1.0.0
   *
   */
   function biopexel_render_counter_section() {
        $options        = biopexel_get_theme_options();
        $counter_column = ! empty( $options['counter_column'] ) ? $options['counter_column'] : 'col-4';
        ?>
        
        <div id="biopexel_counter_section" class="relative page-section same-background">
          <?php if ( is_customize_preview()):
            biopexel_section_tooltip( 'biopexel_counter_section' );
          endif; ?>
            <div class="wrapper">
                <div class="section-content <?php echo esc_attr( $counter_column ); ?> clear">
                  <?php for ( $i = 1; $i <= 4; $i++){
                    $icon =  empty( $options['counter_icon_'.$i] ) ? 'fa-handshake-o' : $options['counter_icon_'.$i] ;
                    ?>
                    <article>
                        <div class="counter-item">
                            <?php if( !empty( $options['counter_value_' . $i] ) ): ?>
                              <h2 class="counter-value"><?php echo esc_html( $options['counter_value_' . $i] ); ?></h2>
                             <?php endif;

                            if( !empty( $options['counter_label_' . $i] ) ): ?>
                                <h3 class="counter-title"><?php echo esc_html( $options['counter_label_' . $i] ); ?></h3>
                            <?php endif; ?>
                        </div><!-- .counter-item -->
                    </article>
                    <?php } ?>
                </div>
            </div>
        </div>
    <?php }
endif; 