<?php
/**
 * Theme Palace options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

/**
 * List of pages for page choices.
 * @return Array Array of page ids and name.
 */
function biopexel_page_choices() {
    $pages = get_pages();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'biopexel' );
    foreach ( $pages as $page ) {
        $choices[ $page->ID ] = $page->post_title;
    }
    return  $choices;
}

/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function biopexel_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'biopexel' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    wp_reset_postdata();
    return  $choices;
}

/**
 * List of category for category choices.
 * @return Array Array of post ids and name.
 */
function biopexel_category_choices() {
    $tax_args = array(
        'hierarchical' => 0,
        'taxonomy'     => 'category',
    );
    $taxonomies = get_categories( $tax_args );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'biopexel' );
    foreach ( $taxonomies as $tax ) {
        $choices[ $tax->term_id ] = $tax->name;
    }
    return  $choices;
}

if ( ! function_exists( 'biopexel_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function biopexel_site_layout() {
        $biopexel_site_layout = array(
            'wide'          => esc_url( get_template_directory_uri() . '/assets/images/full.png' ),
            'boxed-layout'  => esc_url( get_template_directory_uri() . '/assets/images/boxed.png' ),
        );

        $output = apply_filters( 'biopexel_site_layout', $biopexel_site_layout );
        return $output;
    }
endif;

if ( ! function_exists( 'biopexel_selected_sidebar' ) ) :
    /**
     * Sidebars options
     * @return array Sidbar positions
     */
    function biopexel_selected_sidebar() {
        $biopexel_selected_sidebar = array(
            'sidebar-1'             => esc_html__( 'Default Sidebar', 'biopexel' ),
            'optional-sidebar'      => esc_html__( 'Optional Sidebar 1', 'biopexel' ),
            'optional-sidebar-2'    => esc_html__( 'Optional Sidebar 2', 'biopexel' ),
            'optional-sidebar-3'    => esc_html__( 'Optional Sidebar 3', 'biopexel' ),
            'optional-sidebar-4'    => esc_html__( 'Optional Sidebar 4', 'biopexel' ),
        );

        $output = apply_filters( 'biopexel_selected_sidebar', $biopexel_selected_sidebar );

        return $output;
    }
endif;


if ( ! function_exists( 'biopexel_global_sidebar_position' ) ) :
    /**
     * Global Sidebar position
     * @return array Global Sidebar positions
     */
    function biopexel_global_sidebar_position() {
        $biopexel_global_sidebar_position = array(
            'right-sidebar' => esc_url( get_template_directory_uri() . '/assets/images/right.png' ),
            'no-sidebar'    => esc_url( get_template_directory_uri() . '/assets/images/full.png' ),
        );

        $output = apply_filters( 'biopexel_global_sidebar_position', $biopexel_global_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'biopexel_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function biopexel_sidebar_position() {
        $biopexel_sidebar_position = array(
            'right-sidebar'         => esc_url( get_template_directory_uri() . '/assets/images/right.png' ),
            'no-sidebar'            => esc_url( get_template_directory_uri() . '/assets/images/full.png' ),
        );

        $output = apply_filters( 'biopexel_sidebar_position', $biopexel_sidebar_position );

        return $output;
    }
endif;

if ( ! function_exists( 'biopexel_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function biopexel_pagination_options() {
        $biopexel_pagination_options = array(
            'numeric'   => esc_html__( 'Numeric', 'biopexel' ),
            'default'   => esc_html__( 'Default(Older/Newer)', 'biopexel' ),
        );

        $output = apply_filters( 'biopexel_pagination_options', $biopexel_pagination_options );

        return $output;
    }
endif;

if ( ! function_exists( 'biopexel_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function biopexel_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'biopexel' ),
            'off'       => esc_html__( 'Disable', 'biopexel' )
        );
        return apply_filters( 'biopexel_switch_options', $arr );
    }
endif;

if ( ! function_exists( 'biopexel_hide_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function biopexel_hide_options() {
        $arr = array(
            'on'        => esc_html__( 'Yes', 'biopexel' ),
            'off'       => esc_html__( 'No', 'biopexel' )
        );
        return apply_filters( 'biopexel_hide_options', $arr );
    }
endif;

