<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'biopexel_single_post_section',
	array(
		'title'             => esc_html__( 'Single Post','biopexel' ),
		'description'       => esc_html__( 'Options to change the single posts globally.', 'biopexel' ),
		'panel'             => 'biopexel_theme_options_panel',
	)
);

$wp_customize->add_setting( 'biopexel_theme_options[single_post_hide_banner]', array(
	'default'           => $options['single_post_hide_banner'],
	'sanitize_callback' => 'biopexel_sanitize_switch_control',
) );

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize, 'biopexel_theme_options[single_post_hide_banner]', array(
	'label'             => esc_html__( 'Hide Banner', 'biopexel' ),
	'section'           => 'biopexel_single_post_section',
	'on_off_label' 		=> biopexel_hide_options(),
) ) );


// Archive author category setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[single_post_hide_category]',
	array(
		'default'           => $options['single_post_hide_category'],
		'sanitize_callback' => 'biopexel_sanitize_switch_control',
	)
);

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize,
	'biopexel_theme_options[single_post_hide_category]',
		array(
			'label'             => esc_html__( 'Hide Category', 'biopexel' ),
			'section'           => 'biopexel_single_post_section',
			'on_off_label' 		=> biopexel_hide_options(),
		)
	)
);