<?php
/**
 * Reset options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

/**
* Reset section
*/
// Add reset enable section
$wp_customize->add_section( 'biopexel_reset_section',
	array(
		'title'             => esc_html__('Reset all settings','biopexel'),
		'description'       => esc_html__( 'Caution: All settings will be reset to default. Refresh the page after clicking Save & Publish.', 'biopexel' ),
	)
);

// Add reset enable setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[reset_options]',
	array(
		'default'           => $options['reset_options'],
		'sanitize_callback' => 'biopexel_sanitize_checkbox',
		'transport'			=> 'postMessage',
	)
);

$wp_customize->add_control( 'biopexel_theme_options[reset_options]',
	array(
		'label'             => esc_html__( 'Check to reset all settings', 'biopexel' ),
		'section'           => 'biopexel_reset_section',
		'type'              => 'checkbox',
	)
);
