<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'biopexel_pagination',
	array(
		'title'               	=> esc_html__('Pagination','biopexel'),
		'description'         	=> esc_html__( 'Pagination section options.', 'biopexel' ),
		'panel'               	=> 'biopexel_theme_options_panel',
	)
);

// Sidebar position setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[pagination_enable]',
	array(
		'sanitize_callback' 	=> 'biopexel_sanitize_switch_control',
		'default'             	=> $options['pagination_enable'],
	)
);

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize,
	'biopexel_theme_options[pagination_enable]',
		array(
			'label'               	=> esc_html__( 'Pagination Enable', 'biopexel' ),
			'section'             	=> 'biopexel_pagination',
			'on_off_label' 			=> biopexel_switch_options(),
		)
	)
);

// Site layout setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[pagination_type]',
	array(
		'sanitize_callback'   	=> 'biopexel_sanitize_select',
		'default'             	=> $options['pagination_type'],
	)
);

$wp_customize->add_control( 'biopexel_theme_options[pagination_type]',
	array(
		'label'               	=> esc_html__( 'Pagination Type', 'biopexel' ),
		'section'             	=> 'biopexel_pagination',
		'type'                	=> 'select',
		'choices'			  	=> biopexel_pagination_options(),
		'active_callback'	  	=> 'biopexel_is_pagination_enable',
	)
);
