<?php
/**
 * Layout options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'biopexel_layout',
	array(
		'title'               => esc_html__('Layout','biopexel'),
		'description'         => esc_html__( 'Layout section options.', 'biopexel' ),
		'panel'               => 'biopexel_theme_options_panel',
	)
);

// Site layout setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[site_layout]',
	array(
		'sanitize_callback'   => 'biopexel_sanitize_select',
		'default'             => $options['site_layout'],
	)
);

$wp_customize->add_control(  new Biopexel_Custom_Radio_Image_Control ( $wp_customize,
	'biopexel_theme_options[site_layout]',
		array(
			'label'               => esc_html__( 'Site Layout', 'biopexel' ),
			'section'             => 'biopexel_layout',
			'choices'			  => biopexel_site_layout(),
		)
	)
);

// Sidebar position setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[sidebar_position]',
	array(
		'sanitize_callback'   => 'biopexel_sanitize_select',
		'default'             => $options['sidebar_position'],
	)
);

$wp_customize->add_control(  new Biopexel_Custom_Radio_Image_Control ( $wp_customize,
	'biopexel_theme_options[sidebar_position]',
		array(
			'label'               => esc_html__( 'Global Sidebar Position', 'biopexel' ),
			'section'             => 'biopexel_layout',
			'choices'			  => biopexel_global_sidebar_position(),
		)
	)
);

// Post sidebar position setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[post_sidebar_position]',
	array(
		'sanitize_callback'   => 'biopexel_sanitize_select',
		'default'             => $options['post_sidebar_position'],
	)
);

$wp_customize->add_control(  new Biopexel_Custom_Radio_Image_Control ( $wp_customize,
	'biopexel_theme_options[post_sidebar_position]',
		array(
			'label'               => esc_html__( 'Posts Sidebar Position', 'biopexel' ),
			'section'             => 'biopexel_layout',
			'choices'			  => biopexel_sidebar_position(),
		)
	)
);

// Post sidebar position setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[page_sidebar_position]',
	array(
		'sanitize_callback'   => 'biopexel_sanitize_select',
		'default'             => $options['page_sidebar_position'],
	)
);

$wp_customize->add_control( new Biopexel_Custom_Radio_Image_Control( $wp_customize,
	'biopexel_theme_options[page_sidebar_position]',
		array(
			'label'               => esc_html__( 'Pages Sidebar Position', 'biopexel' ),
			'section'             => 'biopexel_layout',
			'choices'			  => biopexel_sidebar_position(),
		)
	)
);