<?php
/**
* Homepage (Static ) options
*
* @package Theme Palace
* @subpackage Biopexel
* @since Biopexel 1.0.0
*/

// Homepage (Static ) setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[enable_frontpage_content]',
	array(
		'sanitize_callback'   => 'biopexel_sanitize_checkbox',
		'default'             => $options['enable_frontpage_content'],
	)
);

$wp_customize->add_control( 'biopexel_theme_options[enable_frontpage_content]',
	array(
		'label'       	=> esc_html__( 'Enable Content', 'biopexel' ),
		'description' 	=> esc_html__( 'Check to enable content on static front page only.', 'biopexel' ),
		'section'     	=> 'static_front_page',
		'type'        	=> 'checkbox',
		'active_callback' => 'biopexel_is_static_homepage_enable',
	)
);