<?php
/**
 * Footer options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

// Footer Section
$wp_customize->add_section( 'biopexel_section_footer',
	array(
		'title'      			=> esc_html__( 'Footer Options', 'biopexel' ),
		'priority'   			=> 900,
		'panel'      			=> 'biopexel_theme_options_panel',
	)
);

// footer text
$wp_customize->add_setting( 'biopexel_theme_options[copyright_text]',
	array(
		'default'       		=> $options['copyright_text'],
		'sanitize_callback'		=> 'biopexel_santize_allow_tag',
		'transport'				=> 'postMessage',
	)
);

$wp_customize->add_control( 'biopexel_theme_options[copyright_text]',
    array(
		'label'      			=> esc_html__( 'Copyright Text', 'biopexel' ),
		'section'    			=> 'biopexel_section_footer',
		'type'		 			=> 'textarea',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[copyright_text]',
		array(
			'selector'            => '.site-info .wrapper',
			'settings'            => 'biopexel_theme_options[copyright_text]',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'biopexel_copyright_text_partial',
		)
	);
}

// scroll top visible
$wp_customize->add_setting( 'biopexel_theme_options[scroll_top_visible]',
	array(
		'default'       	=> $options['scroll_top_visible'],
		'sanitize_callback' => 'biopexel_sanitize_switch_control',
	)
);

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize,
	'biopexel_theme_options[scroll_top_visible]',
		array(
			'label'      		=> esc_html__( 'Display Scroll Top Button', 'biopexel' ),
			'section'    		=> 'biopexel_section_footer',
			'on_off_label' 		=> biopexel_switch_options(),
		)
	)
);