<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'biopexel_excerpt_section',
	array(
		'title'             => esc_html__( 'Excerpt','biopexel' ),
		'description'       => esc_html__( 'Excerpt section options.', 'biopexel' ),
		'panel'             => 'biopexel_theme_options_panel',
	)
);


// long Excerpt length setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[long_excerpt_length]',
	array(
		'sanitize_callback' => 'biopexel_sanitize_number_range',
		'validate_callback' => 'biopexel_validate_long_excerpt',
		'default'			=> $options['long_excerpt_length'],
	)
);

$wp_customize->add_control( 'biopexel_theme_options[long_excerpt_length]',
	array(
		'label'       		=> esc_html__( 'Blog Page Excerpt Length', 'biopexel' ),
		'description' 		=> esc_html__( 'Total words to be displayed in archive page/search page.', 'biopexel' ),
		'section'     		=> 'biopexel_excerpt_section',
		'type'        		=> 'number',
		'input_attrs' 		=> array(
			'style'       => 'width: 80px;',
			'max'         => 100,
			'min'         => 5,
		),
	)
);
