<?php
/**
 * Breadcrumb options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

$wp_customize->add_section( 'biopexel_breadcrumb',
	array(
		'title'             => esc_html__( 'Breadcrumb','biopexel' ),
		'description'       => esc_html__( 'Breadcrumb section options.', 'biopexel' ),
		'panel'             => 'biopexel_theme_options_panel',
	)
);

// Breadcrumb enable setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[breadcrumb_enable]',
	array(
		'sanitize_callback' => 'biopexel_sanitize_switch_control',
		'default'          	=> $options['breadcrumb_enable'],
	)
);

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize,
	'biopexel_theme_options[breadcrumb_enable]',
		array(
			'label'            	=> esc_html__( 'Enable Breadcrumb', 'biopexel' ),
			'section'          	=> 'biopexel_breadcrumb',
			'on_off_label' 		=> biopexel_switch_options(),
		)
	)
);

// Breadcrumb separator setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[breadcrumb_separator]',
	array(
		'sanitize_callback'	=> 'sanitize_text_field',
		'default'          	=> $options['breadcrumb_separator'],
	)
);

$wp_customize->add_control( 'biopexel_theme_options[breadcrumb_separator]',
	array(
		'label'            	=> esc_html__( 'Separator', 'biopexel' ),
		'active_callback' 	=> 'biopexel_is_breadcrumb_enable',
		'section'          	=> 'biopexel_breadcrumb',
	)
);
