<?php
/**
 * Archive options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

// Add archive section
$wp_customize->add_section( 'biopexel_archive_section',
	array(
		'title'             => esc_html__( 'Blog/Archive','biopexel' ),
		'description'       => esc_html__( 'Archive section options.', 'biopexel' ),
		'panel'             => 'biopexel_theme_options_panel',
	)
);

// Your latest posts title setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[your_latest_posts_title]',
	array(
		'default'           => $options['your_latest_posts_title'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control( 'biopexel_theme_options[your_latest_posts_title]',
	array(
		'label'             => esc_html__( 'Your Latest Posts Title', 'biopexel' ),
		'description'       => esc_html__( 'This option only works if Static Front Page is set to "Your latest posts."', 'biopexel' ),
		'section'           => 'biopexel_archive_section',
		'type'				=> 'text',
		'active_callback'	=> function( $control ) {
			return !(
				biopexel_is_static_homepage_enable( $control )
			);
		}
	)
);

$wp_customize->add_setting( 'biopexel_theme_options[hide_banner]', array(
	'default'           => $options['hide_banner'],
	'sanitize_callback' => 'biopexel_sanitize_switch_control',
) );

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize, 'biopexel_theme_options[hide_banner]', array(
	'label'             => esc_html__( 'Hide Banner', 'biopexel' ),
	'section'           => 'biopexel_archive_section',
	'on_off_label' 		=> biopexel_hide_options(),
) ) );

// features content type control and setting
$wp_customize->add_setting( 'biopexel_theme_options[blog_column]',
	array(
		'default'          	=> $options['blog_column'],
		'sanitize_callback' => 'biopexel_sanitize_select',
	)
);

$wp_customize->add_control( 'biopexel_theme_options[blog_column]',
	array(
		'label'             => esc_html__( 'Column Layout', 'biopexel' ),
		'section'           => 'biopexel_archive_section',
		'type'				=> 'select',
		'choices'			=> array( 
			'col-1'		=> esc_html__( 'One Column', 'biopexel' ),
			'col-2'		=> esc_html__( 'Two Column', 'biopexel' ),
			'col-3'		=> esc_html__( 'Three Column', 'biopexel' ),
		),
	)
);
