<?php
/**
 * Testimonial Section options
 *
 * @package Theme Palace
 * @subpackage Biopexel
 * @since Biopexel 1.0.0
 */

// Add Testimonial section
$wp_customize->add_section( 'biopexel_testimonial_section', array(
	'title'             => esc_html__( 'Testimonial','biopexel' ),
	'description'       => esc_html__( 'Testimonial Section options.', 'biopexel' ),
	'panel'             => 'biopexel_front_page_panel',
) );

// Testimonial content enable control and setting
$wp_customize->add_setting( 'biopexel_theme_options[testimonial_section_enable]', array(
	'default'			=> 	$options['testimonial_section_enable'],
	'sanitize_callback' => 'biopexel_sanitize_switch_control',
) );

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize, 'biopexel_theme_options[testimonial_section_enable]', array(
	'label'             => esc_html__( 'Testimonial Section Enable', 'biopexel' ),
	'section'           => 'biopexel_testimonial_section',
	'on_off_label' 		=> biopexel_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[testimonial_section_enable]', array(
		'selector'            => '#biopexel_testimonial_section .tooltiptext',
		'settings'            => 'biopexel_theme_options[testimonial_section_enable]',
    ) );
}

for ( $i = 1; $i <= 3; $i++ ) :
	// testimonial pages drop down chooser control and setting
	$wp_customize->add_setting( 'biopexel_theme_options[testimonial_content_page_' . $i . ']', array(
		'sanitize_callback' => 'biopexel_sanitize_page',
	) );

	$wp_customize->add_control( new Biopexel_Dropdown_Chooser( $wp_customize, 'biopexel_theme_options[testimonial_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'biopexel' ), $i ),
		'section'           => 'biopexel_testimonial_section',
		'choices'			=> biopexel_page_choices(),
		'active_callback'	=> 'biopexel_is_testimonial_section_enable',
	) ) );

	// testimonial position setting and control
	$wp_customize->add_setting( 'biopexel_theme_options[testimonial_position_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'biopexel_theme_options[testimonial_position_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Position %d', 'biopexel' ), $i ),
		'section'        	=> 'biopexel_testimonial_section',
		'active_callback' 	=> 'biopexel_is_testimonial_section_enable',
		'type'				=> 'text',
	) );

	// testimonial hr setting and control
	$wp_customize->add_setting( 'biopexel_theme_options[testimonial_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Biopexel_Customize_Horizontal_Line( $wp_customize, 'biopexel_theme_options[testimonial_hr_'. $i .']',
		array(
			'section'         => 'biopexel_testimonial_section',
			'active_callback' => 'biopexel_is_testimonial_section_enable',
			'type'			  => 'hr'
	) ) );
endfor;