<?php
/**
 * Service Section options
 *
 * @package Theme Palace
 * @subpackage Biopexel
 * @since Biopexel 1.0.0
 */

// Add Service section
$wp_customize->add_section( 'biopexel_service_section', array(
	'title'             => esc_html__( 'Services','biopexel' ),
	'description'       => esc_html__( 'Services Section options.', 'biopexel' ),
	'panel'             => 'biopexel_front_page_panel',
) );

// Service content enable control and setting
$wp_customize->add_setting( 'biopexel_theme_options[service_section_enable]', array(
	'default'			=> 	$options['service_section_enable'],
	'sanitize_callback' => 'biopexel_sanitize_switch_control',
) );

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize, 'biopexel_theme_options[service_section_enable]', array(
	'label'             => esc_html__( 'Service Section Enable', 'biopexel' ),
	'section'           => 'biopexel_service_section',
	'on_off_label' 		=> biopexel_switch_options(),
) ) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[service_section_enable]', array(
		'selector'      => '#biopexel_service_section .tooltiptext',
		'settings'      => 'biopexel_theme_options[service_section_enable]',
    ) );
}

// about title setting and control
$wp_customize->add_setting( 'biopexel_theme_options[service_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['service_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'biopexel_theme_options[service_title]', array(
	'label'           	=> esc_html__( 'Title', 'biopexel' ),
	'section'        	=> 'biopexel_service_section',
	'type'				=> 'text',
	'active_callback' 	=> 'biopexel_is_service_section_enable',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[service_title]', array(
		'selector'            => '#biopexel_service_section h2.section-title',
		'settings'            => 'biopexel_theme_options[service_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'biopexel_service_title_partial',
    ) );
}


// Service Excerpt length setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[service_excerpt_length]',
	array(
		'sanitize_callback' => 'biopexel_sanitize_number_range',
		'default'			=> $options['service_excerpt_length'],
	)
);

$wp_customize->add_control( 'biopexel_theme_options[service_excerpt_length]',
	array(
		'label'       		=> esc_html__( 'Excerpt Length', 'biopexel' ),
		'description' 		=> esc_html__( 'Total words to be displayed in Service section', 'biopexel' ),
		'section'     		=> 'biopexel_service_section',
		'type'        		=> 'number',
		'active_callback' 	=> 'biopexel_is_service_section_enable',
	)
);


for ( $i = 1; $i <= 4; $i++ ) :

	// service note control and setting
	$wp_customize->add_setting( 'biopexel_theme_options[service_content_icon_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new Biopexel_Icon_Picker( $wp_customize, 'biopexel_theme_options[service_content_icon_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Icon %d', 'biopexel' ), $i ),
		'section'           => 'biopexel_service_section',
		'active_callback'	=> 'biopexel_is_service_section_enable',
	) ) );

	// service pages drop down chooser control and setting
	$wp_customize->add_setting( 'biopexel_theme_options[service_content_page_' . $i . ']', array(
		'sanitize_callback' => 'biopexel_sanitize_page',
	) );

	$wp_customize->add_control( new Biopexel_Dropdown_Chooser( $wp_customize, 'biopexel_theme_options[service_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'biopexel' ), $i ),
		'section'           => 'biopexel_service_section',
		'choices'			=> biopexel_page_choices(),
		'active_callback'	=> 'biopexel_is_service_section_enable',
	) ) );

	// service hr setting and control
	$wp_customize->add_setting( 'biopexel_theme_options[service_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Biopexel_Customize_Horizontal_Line( $wp_customize, 'biopexel_theme_options[service_hr_'. $i .']',
		array(
			'section'         => 'biopexel_service_section',
			'active_callback' => 'biopexel_is_service_section_enable',
			'type'			  => 'hr'
	) ) );

endfor;