<?php
/**
 * project Section options
 *
 * @package Theme Palace
 * @subpackage Power News Pro
 * @since Power News Pro 1.0.0
 */

// Add project section
$wp_customize->add_section( 'biopexel_project_section', array(
	'title'             => esc_html__( 'Project','biopexel' ),
	'description'       => esc_html__( 'project Section options.', 'biopexel' ),
	'panel'             => 'biopexel_front_page_panel',
) );

// project content enable control and setting
$wp_customize->add_setting( 'biopexel_theme_options[project_section_enable]', array(
	'default'			=> 	$options['project_section_enable'],
	'sanitize_callback' => 'biopexel_sanitize_switch_control',
) );

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize, 'biopexel_theme_options[project_section_enable]', array(
	'label'             => esc_html__( 'project Section Enable', 'biopexel' ),
	'section'           => 'biopexel_project_section',
	'on_off_label' 		=> biopexel_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[project_section_enable]', array(
		'selector'      => '#biopexel_project_section .tooltiptext',
		'settings'      => 'biopexel_theme_options[project_section_enable]',
    ) );
}

// project pages drop down chooser control and setting
$wp_customize->add_setting( 'biopexel_theme_options[project_content_page]', array(
	'sanitize_callback' => 'biopexel_sanitize_page',
) );

$wp_customize->add_control( new Biopexel_Dropdown_Chooser( $wp_customize, 'biopexel_theme_options[project_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'biopexel' ),
	'section'           => 'biopexel_project_section',
	'choices'			=> biopexel_page_choices(),
	'active_callback'	=> 'biopexel_is_project_section_enable',
) ) );


// project btn title setting and control
$wp_customize->add_setting( 'biopexel_theme_options[project_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'           => $options['project_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'biopexel_theme_options[project_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'biopexel' ),
	'section'        	=> 'biopexel_project_section',
	'active_callback' 	=> 'biopexel_is_project_section_enable',
	'type'				=> 'text',
) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[project_btn_title]', array(
		'selector'            => '#biopexel_project_section .btn',
		'settings'            => 'biopexel_theme_options[project_btn_title]',
		'fallback_refresh'    => true,
		'container_inclusive' => false,
		'render_callback'     => 'biopexel_project_btn_title_partial',
    ) );
}