<?php
/**
 * Latest Blog Section options
 *
 * @package Theme Palace
 * @subpackage Biopexel
 * @since Biopexel 1.0.0
 */

// Add Latest Blog section
$wp_customize->add_section( 'biopexel_latest_blog_section',
    array(
        'title'             => esc_html__( 'Latest Blog','biopexel' ),
        'description'       => esc_html__( 'Latest Blog Section options.', 'biopexel' ),
        'panel'             => 'biopexel_front_page_panel',
    )
);

// Latest Blog content enable control and setting
$wp_customize->add_setting( 'biopexel_theme_options[latest_blog_section_enable]',
    array(
        'default'           =>  $options['latest_blog_section_enable'],
        'sanitize_callback' => 'biopexel_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize,
    'biopexel_theme_options[latest_blog_section_enable]',
        array(
            'label'             => esc_html__( 'Latest Blog Section Enable', 'biopexel' ),
            'section'           => 'biopexel_latest_blog_section',
            'on_off_label'      => biopexel_switch_options(),
        ) 
    )
);

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[latest_blog_section_enable]', array(
        'selector'      => '#biopexel_latest_blog_section .tooltiptext',
        'settings'      => 'biopexel_theme_options[latest_blog_section_enable]',
    ) );
}


// latest_post title setting and control
$wp_customize->add_setting( 'biopexel_theme_options[latest_blog_title]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => $options['latest_blog_title'],
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'biopexel_theme_options[latest_blog_title]',
    array(
        'label'             => esc_html__( 'Section Title', 'biopexel' ),
        'section'           => 'biopexel_latest_blog_section',
        'active_callback'   => 'biopexel_is_latest_blog_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[latest_blog_title]',
        array(
            'selector'            => '#biopexel_latest_blog_section .section-header h2',
            'settings'            => 'biopexel_theme_options[latest_blog_title]',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'biopexel_latest_blog_title_partial',
        )
    );
}

// About Excerpt length setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[latest_blog_excerpt_length]',
	array(
		'sanitize_callback' => 'biopexel_sanitize_number_range',
		'default'			=> $options['latest_blog_excerpt_length'],
	)
);

$wp_customize->add_control( 'biopexel_theme_options[latest_blog_excerpt_length]',
	array(
		'label'       		=> esc_html__( 'Excerpt Length', 'biopexel' ),
		'description' 		=> esc_html__( 'Total words to be displayed in About section', 'biopexel' ),
		'section'     		=> 'biopexel_latest_blog_section',
		'type'        		=> 'number',
		'active_callback' 	=> 'biopexel_is_latest_blog_section_enable',
	)
);

for ( $i = 1; $i <= 3; $i++ ) :

    // latest_post posts drop down chooser control and setting
    $wp_customize->add_setting( 'biopexel_theme_options[latest_blog_content_post_' . $i . ']',
        array(
            'sanitize_callback' => 'biopexel_sanitize_page',
        )
    );

    $wp_customize->add_control( new Biopexel_Dropdown_Chooser( $wp_customize,
        'biopexel_theme_options[latest_blog_content_post_' . $i . ']',
            array(
                'label'             => sprintf( esc_html__( 'Select Post %d', 'biopexel' ), $i ),
                'section'           => 'biopexel_latest_blog_section',
                'choices'           => biopexel_post_choices(),
                'active_callback'   => 'biopexel_is_latest_blog_section_enable',
            ) 
        )
    );

    //latest_post separator
    $wp_customize->add_setting('biopexel_theme_options[latest_blog_separator'. $i .']',
        array(
            'sanitize_callback'      => 'biopexel_sanitize_html',
        )
    );

    $wp_customize->add_control(new Biopexel_Customize_Horizontal_Line($wp_customize,
        'biopexel_theme_options[latest_blog_separator'. $i .']',
            array(
                'active_callback'       => 'biopexel_is_latest_blog_section_enable',
                'type'                  =>'hr',
                'section'               =>'biopexel_latest_blog_section',
                'active_callback'       => 'biopexel_is_latest_blog_section_enable',
            )
        )
    );
    
endfor;

// Popular Post Read More content setting
$wp_customize->add_setting('biopexel_theme_options[latest_blog_read_more_btn_label]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'transport'			=> 'postMessage',
        'default'           => $options['latest_blog_read_more_btn_label']

    )
);

$wp_customize->add_control('biopexel_theme_options[latest_blog_read_more_btn_label]',
    array(
        'section'			=> 'biopexel_latest_blog_section',
        'label'				=> esc_html__( 'Read More Button Label', 'biopexel' ),
        'type'          	=>'text',
        'active_callback'   => 'biopexel_is_latest_blog_section_enable',
    )
);


// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[latest_blog_read_more_btn_label]',
        array(
            'selector'            => '#biopexel_latest_blog_section .read-more .btn',
            'settings'            => 'biopexel_theme_options[latest_blog_read_more_btn_label]',
            'fallback_refresh'    => true,
            'container_inclusive' => false,
            'render_callback'     => 'biopexel_latest_blog_read_more_btn_label_partial',
        ) 
    );
}

// latest_blog_btn link setting and control
$wp_customize->add_setting( 'biopexel_theme_options[latest_blog_btn_link]', array(
    'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'biopexel_theme_options[latest_blog_btn_link]', array(
    'label'             => esc_html__( 'Button Link', 'biopexel' ),
    'section'           => 'biopexel_latest_blog_section',
    'type'              => 'url',
    'active_callback'   => 'biopexel_is_latest_blog_section_enable',
) );
