<?php
/**
 * Instagram Section options
 *
 * @package Theme Palace
 * @subpackage Biopexel
 * @since Biopexel 1.0.0
 */

// Instagram section
$wp_customize->add_section('biopexel_instagram_section',
	array(
		'title'         => esc_html__( 'Instagram', 'biopexel' ),
		'description'   => sprintf( esc_html__( '%1$s Smash Balloon Social Photo Feed %2$s should be active and site should be connected to instagram account for this section to work.', 'biopexel' ), '<a target="_blank" href="https://wordpress.org/plugins/instagram-feed/">', '</a>' ),
		'panel'         => 'biopexel_front_page_panel',
	)
);

// Instagram enable setting
$wp_customize->add_setting('biopexel_theme_options[instagram_section_enable]',
    array(
        'sanitize_callback' => 'biopexel_sanitize_switch_control',
        'default'           => $options['instagram_section_enable'],
    )
);

$wp_customize->add_control(new Biopexel_Switch_Control($wp_customize,
    'biopexel_theme_options[instagram_section_enable]',
        array(
            'section'		=> 'biopexel_instagram_section',
            'label'			=> esc_html__( 'Enable instagram.', 'biopexel' ),
            'on_off_label'  => biopexel_switch_options(),
        )
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[instagram_section_enable]', array(
        'selector'      => '#biopexel_instagram_section .tooltiptext',
        'settings'      => 'biopexel_theme_options[instagram_section_enable]',
    ) );
}

// Subscribe title setting
$wp_customize->add_setting('biopexel_theme_options[instagram_section_title]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => $options['instagram_section_title'],
        'transport'	        => 'postMessage',
    )
);

$wp_customize->add_control('biopexel_theme_options[instagram_section_title]',
    array(
        'section'		    => 'biopexel_instagram_section',
        'label'			    => esc_html__( 'Section Title:', 'biopexel' ),
        'active_callback'   => 'biopexel_is_instagram_section_enable',
        'type'              =>'text'
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[instagram_section_title]',
		array(
			'selector'            => '#biopexel_instagram_section h2.section-title',
			'settings'            => 'biopexel_theme_options[instagram_section_title]',
			'fallback_refresh'    => true,
			'container_inclusive' => false,
			'render_callback'     => 'biopexel_instagram_section_title_partial',
		) 
	);
}

// Subscribe button text setting
$wp_customize->add_setting('biopexel_theme_options[instagram_section_shortcode]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => $options['instagram_section_shortcode'],
    )
);

$wp_customize->add_control('biopexel_theme_options[instagram_section_shortcode]',
    array(
        'section'		    => 'biopexel_instagram_section',
        'label'			    => esc_html__( 'Shortcode:', 'biopexel' ),
        'active_callback'   => 'biopexel_is_instagram_section_enable',
        'type'              =>'textarea'

    )
);
    
