<?php
/**
 * Header Content Section options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

// Add Header Content section
$wp_customize->add_section( 'biopexel_header_content_section',
	array(
		'title'             => esc_html__( 'Header Content','biopexel' ),
		'description'       => esc_html__( 'Header Content Section options.', 'biopexel' ),
		'panel'             => 'biopexel_front_page_panel',
	)
);

// Header Content content enable control and setting
$wp_customize->add_setting( 'biopexel_theme_options[header_content_section_enable]', 
	array(
		'default'			=> 	$options['header_content_section_enable'],
		'sanitize_callback' => 'biopexel_sanitize_switch_control',
	) 
);

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize,
	'biopexel_theme_options[header_content_section_enable]',
		array(
			'label'             => esc_html__( 'Header Content Section Enable', 'biopexel' ),
			'section'           => 'biopexel_header_content_section',
			'on_off_label' 		=> biopexel_switch_options(),
		)
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[header_content_section_enable]', array(
		'selector'      => '#biopexel_header_content_section .tooltiptext',
		'settings'      => 'biopexel_theme_options[header_content_section_enable]',
    ) );
}


// about posts drop down chooser control and setting
$wp_customize->add_setting( 'biopexel_theme_options[header_content_content_post]', array(
	'sanitize_callback' => 'biopexel_sanitize_page',
) );

$wp_customize->add_control( new Biopexel_Dropdown_Chooser( $wp_customize, 'biopexel_theme_options[header_content_content_post]', array(
	'label'             => esc_html__( 'Select Post', 'biopexel' ),
	'section'           => 'biopexel_header_content_section',
	'choices'			=> biopexel_post_choices(),
	'active_callback'	=> 'biopexel_is_header_content_section_enable',
) ) );