<?php
/**
 * Call To Action Section options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 */

// Add Call To Action section
$wp_customize->add_section( 'biopexel_cta_section',
    array(
        'title'             => esc_html__( 'Call To Action','biopexel' ),
        'description'       => esc_html__( 'Call To Action Section options.', 'biopexel' ),
        'panel'             => 'biopexel_front_page_panel',
    )
);

// Call To Action content enable control and setting
$wp_customize->add_setting( 'biopexel_theme_options[cta_section_enable]',
    array(
        'default'			=> 	$options['cta_section_enable'],
        'sanitize_callback' => 'biopexel_sanitize_switch_control',
    )
);

$wp_customize->add_control( new biopexel_Switch_Control( $wp_customize,
    'biopexel_theme_options[cta_section_enable]',
        array(
            'label'             => esc_html__( 'Call To Action Section Enable', 'biopexel' ),
            'section'           => 'biopexel_cta_section',
            'on_off_label' 		=> biopexel_switch_options(),
        )
    )
);

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[cta_section_enable]', array(
        'selector'            => '#biopexel_cta_section .tooltiptext',
        'settings'            => 'biopexel_theme_options[cta_section_enable]',
    ) );
}

// cta section sub title control and setting
$wp_customize->add_setting('biopexel_theme_options[cta_sub_title]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'transport' => 'postMessage',
        'default'  => $options['cta_sub_title'],
    )
);

$wp_customize->add_control('biopexel_theme_options[cta_sub_title]',
    array(
        'label' => esc_html__('Section Sub Title', 'biopexel'),
        'section' => 'biopexel_cta_section',
        'type' => 'text',
        'active_callback' => 'biopexel_is_cta_section_enable',
    )
);

$wp_customize->selective_refresh->add_partial('biopexel_theme_options[cta_sub_title]',
    array(
        'selector' => '#biopexel_cta_section h2.section-title',
        'render_callback' => 'biopexel_cta_sub_title_partial',
    )
);


$wp_customize->add_setting( 'biopexel_theme_options[cta_content_page]',
    array(
        'sanitize_callback' => 'biopexel_sanitize_page',
    )
);

$wp_customize->add_control( new biopexel_Dropdown_Chooser( $wp_customize,
    'biopexel_theme_options[cta_content_page]',
        array(
            'label'             => esc_html__( 'Select Page', 'biopexel' ),
            'section'           => 'biopexel_cta_section',
            'choices'			=> biopexel_page_choices(),
            'active_callback'	=> 'biopexel_is_cta_section_enable',
        )
    )
);

// Call To Action read more setting and control
$wp_customize->add_setting( 'biopexel_theme_options[cta_read_more]',
    array(
        'default'			=> $options['cta_read_more'],
        'sanitize_callback' => 'sanitize_text_field',
        'transport'         =>'postMessage',
    )
);

$wp_customize->add_control( 'biopexel_theme_options[cta_read_more]',
    array(
        'label'           	=> esc_html__( 'Read More Text', 'biopexel' ),
        'section'        	=> 'biopexel_cta_section',
        'active_callback' 	=> 'biopexel_is_cta_section_enable',
        'type'				=> 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[cta_read_more]',
        array(
            'selector'            => '#biopexel_cta_section div.read-more a.btn',
            'settings'            => 'biopexel_theme_options[cta_read_more]',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'biopexel_cta_read_more_partial',
        )
    );
}

// Call To Action Excerpt length setting and control.
$wp_customize->add_setting( 'biopexel_theme_options[cta_excerpt_length]',
	array(
		'sanitize_callback' => 'biopexel_sanitize_number_range',
		'default'			=> $options['cta_excerpt_length'],
	)
);

$wp_customize->add_control( 'biopexel_theme_options[cta_excerpt_length]',
	array(
		'label'       		=> esc_html__( 'Excerpt Length', 'biopexel' ),
		'description' 		=> esc_html__( 'Total words to be displayed in Call To Action section', 'biopexel' ),
		'section'     		=> 'biopexel_cta_section',
		'type'        		=> 'number',
        'active_callback'	=> 'biopexel_is_cta_section_enable',
	)
);
