<?php
/**
 * Counter Section options
 *
 * @package Theme Palace
 * @subpackage Biopexel
 * @since Biopexel 1.0.0
 */

// Add Counter section
$wp_customize->add_section( 'biopexel_counter_section', array(
	'title'             => esc_html__( 'Counter','biopexel' ),
	'description'       => esc_html__( 'Counter Section options.', 'biopexel' ),
	'panel'             => 'biopexel_front_page_panel',
) );

// Counter content enable control and setting
$wp_customize->add_setting( 'biopexel_theme_options[counter_section_enable]', array(
	'default'			=> 	$options['counter_section_enable'],
	'sanitize_callback' => 'biopexel_sanitize_switch_control',
) );

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize, 'biopexel_theme_options[counter_section_enable]', array(
	'label'             => esc_html__( 'Counter Section Enable', 'biopexel' ),
	'section'           => 'biopexel_counter_section',
	'on_off_label' 		=> biopexel_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[counter_section_enable]', array(
		'selector'            => '#biopexel_counter_section .tooltiptext',
		'settings'            => 'biopexel_theme_options[counter_section_enable]',
    ) );
}


// Counter content type control and setting
$wp_customize->add_setting( 'biopexel_theme_options[counter_column]', array(
	'default'          	=> $options['counter_column'],
	'sanitize_callback' => 'biopexel_sanitize_select',
) );

$wp_customize->add_control( 'biopexel_theme_options[counter_column]', array(
	'label'             => esc_html__( 'Column Layout', 'biopexel' ),
	'section'           => 'biopexel_counter_section',
	'type'				=> 'select',
	'active_callback' 	=> 'biopexel_is_counter_section_enable',
	'choices'			=> array(
		'col-3'      => esc_html__( 'Three Column', 'biopexel' ),
		'col-4'      => esc_html__( 'Four Column', 'biopexel' ),
		),
) );

for ( $i = 1; $i <= 4; $i++ ) :

	// counter title setting and control
	$wp_customize->add_setting( 'biopexel_theme_options[counter_value_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'biopexel_theme_options[counter_value_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Value %d', 'biopexel' ), $i ),
		'section'        	=> 'biopexel_counter_section',
		'active_callback' 	=> 'biopexel_is_counter_section_enable',
		'type'				=> 'text',
	) );

	// counter position setting and control
	$wp_customize->add_setting( 'biopexel_theme_options[counter_label_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'biopexel_theme_options[counter_label_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Label %d', 'biopexel' ), $i ),
		'section'        	=> 'biopexel_counter_section',
		'active_callback' 	=> 'biopexel_is_counter_section_enable',
		'type'				=> 'text',
	) );

	// counter hr setting and control
	$wp_customize->add_setting( 'biopexel_theme_options[counter_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Biopexel_Customize_Horizontal_Line( $wp_customize, 'biopexel_theme_options[counter_hr_'. $i .']',
		array(
			'section'         => 'biopexel_counter_section',
			'active_callback' => 'biopexel_is_counter_section_enable',
			'type'			  => 'hr'
	) ) );
endfor;