<?php
/**
 * About Section options
 *
 * @package Theme Palace
 * @subpackage Fairtimes Pro
 * @since Fairtimes Pro 1.0.0
 */

// Add About section
$wp_customize->add_section( 'biopexel_about_section', array(
	'title'             => esc_html__( 'About Us','biopexel' ),
	'description'       => esc_html__( 'About Section options.', 'biopexel' ),
	'panel'             => 'biopexel_front_page_panel',
) );

// About content enable control and setting
$wp_customize->add_setting( 'biopexel_theme_options[about_section_enable]', array(
	'default'			=> 	$options['about_section_enable'],
	'sanitize_callback' => 'biopexel_sanitize_switch_control',
) );

$wp_customize->add_control( new Biopexel_Switch_Control( $wp_customize, 'biopexel_theme_options[about_section_enable]', array(
	'label'             => esc_html__( 'About Section Enable', 'biopexel' ),
	'section'           => 'biopexel_about_section',
	'on_off_label' 		=> biopexel_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[about_section_enable]', array(
		'selector'      => '#biopexel_about_section .tooltiptext',
		'settings'      => 'biopexel_theme_options[about_section_enable]',
    ) );
}

// about subtitle setting and control
$wp_customize->add_setting( 'biopexel_theme_options[about_subtitle]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['about_subtitle'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'biopexel_theme_options[about_subtitle]', array(
	'label'           	=> esc_html__( 'Sub Title', 'biopexel' ),
	'section'        	=> 'biopexel_about_section',
	'active_callback' 	=> 'biopexel_is_about_section_enable',
	'type'				=> 'text',
) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[about_subtitle]', array(
		'selector'            => '#biopexel_about_section h2.section-title',
		'settings'            => 'biopexel_theme_options[about_subtitle]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'biopexel_about_subtitle_partial',
    ) );
}

// about pages drop down chooser control and setting
$wp_customize->add_setting( 'biopexel_theme_options[about_content_page]', array(
	'sanitize_callback' => 'biopexel_sanitize_page',
) );

$wp_customize->add_control( new Biopexel_Dropdown_Chooser( $wp_customize, 'biopexel_theme_options[about_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'biopexel' ),
	'section'           => 'biopexel_about_section',
	'choices'			=> biopexel_page_choices(),
	'active_callback'	=> 'biopexel_is_about_section_enable',
) ) );

// about btn title setting and control
$wp_customize->add_setting( 'biopexel_theme_options[about_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'           => $options['about_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'biopexel_theme_options[about_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'biopexel' ),
	'section'        	=> 'biopexel_about_section',
	'active_callback' 	=> 'biopexel_is_about_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'biopexel_theme_options[about_btn_title]', array(
		'selector'            => '#biopexel_about_section .btn',
		'settings'            => 'biopexel_theme_options[about_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'biopexel_about_btn_title_partial',
    ) );
}