<?php
/**
 * Customizer default options
 *
 * @package Theme Palace
 * @subpackage  Biopexel
 * @since  Biopexel 1.0.0
 * @return array An array of default values
 */

function biopexel_get_default_theme_options() {
	$theme_data = wp_get_theme();
	$biopexel_default_options = array(
		// Color Options
		'header_title_color'			    => '#000',
		'header_tagline_color'			    => '#000',
		'header_txt_logo_extra'			    => 'show-all',
		'colorscheme_hue'				    => '#d87b4d',
		'colorscheme'					    => 'default',
		'theme_version'						=> 'lite-version',
		'home_layout'						=> 'default-design',

		// typography Options
		'theme_typography' 				    => 'default',
		'body_theme_typography' 		    => 'default',
		
		// loader
		'loader_enable'         		    => (bool) false,
		'loader_icon'         			    => 'default',

		// breadcrumb
		'breadcrumb_enable'				    => (bool) true,
		'breadcrumb_separator'			    => '/',
				
		// homepage options
		'enable_frontpage_content' 			=> false,

		// layout 
		'site_layout'         			    => 'wide',
		'sidebar_position'         		    => 'right-sidebar',
		'post_sidebar_position' 		    => 'right-sidebar',
		'page_sidebar_position' 		    => 'right-sidebar',

		// excerpt options
		'long_excerpt_length'               => 25,

		// pagination options
		'pagination_enable'         	    => (bool) true,
		'pagination_type'         		    => 'default',

		// footer options
		'copyright_text'           		    => sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s. ', '1: Year, 2: Site Title with home URL', 'biopexel' ), '[the-year]', '[site-link]' ) . esc_html__( 'All Rights Reserved | ', 'biopexel' ) . esc_html( $theme_data->get( 'Name') ) . '&nbsp;' . esc_html__( 'by', 'biopexel' ). '&nbsp;<a target="_blank" href="'. esc_url( $theme_data->get( 'AuthorURI' ) ) .'">'. esc_html( ucwords( $theme_data->get( 'Author' ) ) ) .'</a>',
		'scroll_top_visible'        	    => (bool) true,

		// reset options
		'reset_options'      			    => (bool) false,
		
		// homepage sections sortable
		'all_sortable' 			    	   => 'header_content,counter,service,about,testimonial,cta,project,latest_blog,instagram',
		

		// blog/archive options
		'your_latest_posts_title' 		    => esc_html__( 'Blogs', 'biopexel' ),
		'blog_column'						=> 'col-2',


		// single post theme options
		'single_post_hide_banner'		    => (bool) false,
		'single_post_hide_category'		    => (bool) false,
		'hide_banner' 				        => (bool) false,

		// banner settings
		'banner_settings_enable'            => (bool) true,

		/* Front Page */

		// top bar
		'social_menu_enable'				   => (bool) true,
		
		// Slider
		'featured_slider_section_enable'	   => (bool) false,
		'featured_slider_content_type'		   => 'post',
		'featured_slider_count'				   => 3,
		'featured_slider_autoplay_enable'	   => (bool) false,
		'featured_slider_excerpt_length'	   => 25,
		'featured_slider_btn_txt'              => esc_html__('Learn More','biopexel'),
		'featured_slider_btn_alt_txt'          => esc_html__('Get Started','biopexel'),
		// header content
		'header_content_section_enable'		   => (bool) false,

		// Counter
		'counter_section_enable'		       => (bool) false,
		'counter_column'				       => 'col-4',

		// Service
		'service_section_enable'		       => (bool) false,
		'service_title'                        => esc_html__('Services','biopexel'),
		'service_excerpt_length'		       => 20,

		// about
		'about_section_enable'                 => (bool) false,
		'about_btn_title'	                   => esc_html__( 'Read More', 'biopexel' ),
		'about_subtitle'				       => esc_html__( 'About', 'biopexel' ),
		

		// testimonial
		'testimonial_section_enable'	       => (bool) false,

		// cta
		'cta_section_enable' 		           => (bool) false,
		'cta_read_more'				           => esc_html__('Read More', 'biopexel'),
		'cta_sub_title'				           => esc_html__('Call to Action', 'biopexel'),
		'cta_excerpt_length'	               => 25,

		// project
		'project_section_enable'			   => (bool) false,
		'project_btn_title'	                   => esc_html__( 'Contact Me', 'biopexel' ),

		// latest_blog
		'latest_blog_section_enable'		   => (bool) false,
		'latest_blog_title'    			       => esc_html__('News & Articles','biopexel'),
		'latest_blog_read_more_btn_label'      => esc_html__('Read Story','biopexel'),
		'latest_blog_excerpt_length'		   => 20,

		// instagram
		'instagram_section_enable' 		       => (bool) false,
		'instagram_section_title'		       => esc_html__('Instagram', 'biopexel'),
		'instagram_section_shortcode'	       => '[instagram-feed showheader=false num=5 cols=5 showfollow=false showbutton=false]',


	);

	$output = apply_filters( 'biopexel_default_theme_options', $biopexel_default_options );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}