<?php
/**
 * Customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage  Biopexel Pro
 * @since  Biopexel Pro 1.0.0
 */

if ( ! function_exists( 'biopexel_is_topbar_section_enable' ) ) :
	/**
	 * Check if loader is enabled.
	 *
	 * @since  Biopexel Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function biopexel_is_topbar_section_enable( $control ) {
		return $control->manager->get_setting( 'biopexel_theme_options[topbar_section_enable]' )->value();
	}
endif;

if ( ! function_exists( 'biopexel_is_static_homepage_enable' ) ) :
	/**
	 * Check if static homepage is enabled.
	 *
	 * @since Biopexel Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function biopexel_is_static_homepage_enable( $control ) {
		return ( 'page' == $control->manager->get_setting( 'show_on_front' )->value() );
	}
endif;

if ( ! function_exists( 'biopexel_is_breadcrumb_enable' ) ) :
	/**
	 * Check if breadcrumb is enabled.
	 *
	 * @since  Biopexel Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function biopexel_is_breadcrumb_enable( $control ) {
		return $control->manager->get_setting( 'biopexel_theme_options[breadcrumb_enable]' )->value();
	}
endif;

if ( ! function_exists( 'biopexel_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since  Biopexel Pro 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function biopexel_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'biopexel_theme_options[pagination_enable]' )->value();
	}
endif;

/*==================Header Content===============*/

/**
 * Check if about section is enabled.
 *
 * @since Biopexel Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function biopexel_is_header_content_section_enable( $control ) {
	return ( $control->manager->get_setting( 'biopexel_theme_options[header_content_section_enable]' )->value() );
}

/*===================Counter====================*/

/**
 * Check if counter section is enabled.
 *
 * @since Biopexel Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function biopexel_is_counter_section_enable( $control ) {
	return ( $control->manager->get_setting( 'biopexel_theme_options[counter_section_enable]' )->value() );
}

/*==================Services===============*/

/**
 * Check if service section is enabled.
 *
 * @since Biopexel Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function biopexel_is_service_section_enable( $control ) {
	return ( $control->manager->get_setting( 'biopexel_theme_options[service_section_enable]' )->value() );
}

/*==================About Us===============*/

/**
 * Check if about section is enabled.
 *
 * @since Biopexel Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function biopexel_is_about_section_enable( $control ) {
	return ( $control->manager->get_setting( 'biopexel_theme_options[about_section_enable]' )->value() );
}

/**
 * Check if Call To Action section is enabled.
 *
 * @since  Biopexel 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function biopexel_is_cta_section_enable( $control ) {
	return ( $control->manager->get_setting( 'biopexel_theme_options[cta_section_enable]' )->value() );
}

/*==================Testimonial===============*/

/**
 * Check if testimonial section is enabled.
 *
 * @since Fairtimes Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function biopexel_is_testimonial_section_enable( $control ) {
	return ( $control->manager->get_setting( 'biopexel_theme_options[testimonial_section_enable]' )->value() );
}

/*==================About Us===============*/

/**
 * Check if about section is enabled.
 *
 * @since Biopexel Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function biopexel_is_project_section_enable( $control ) {
	return ( $control->manager->get_setting( 'biopexel_theme_options[project_section_enable]' )->value() );
}

/**
 * Check if latest_blog section is enabled.
 *
 * @since  Biopexel Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function biopexel_is_latest_blog_section_enable( $control ) {
	return ( $control->manager->get_setting( 'biopexel_theme_options[latest_blog_section_enable]' )->value() );
}

/*==================Instagram===============*/

/**
 * Check if instagram section is enabled.
 *
 * @since Music Zone Pro 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function biopexel_is_instagram_section_enable( $control ) {
	return ( $control->manager->get_setting( 'biopexel_theme_options[instagram_section_enable]' )->value() );
}