<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package Theme Palace
	 * @subpackage  Biopexel
	 * @since  Biopexel 1.0.0
	 */

	/**
	 * biopexel_doctype hook
	 *
	 * @hooked biopexel_doctype -  10
	 *
	 */
	do_action( 'biopexel_doctype' );

?>
<head>
<?php
	/**
	 * biopexel_before_wp_head hook
	 *
	 * @hooked biopexel_head -  10
	 *
	 */
	do_action( 'biopexel_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>
<?php
	/**
	 * biopexel_page_start_action hook
	 *
	 * @hooked biopexel_page_start -  10
	 *
	 */
	do_action( 'biopexel_page_start_action' ); 

	/**
	 * biopexel_header_action hook
	 *
	 * @hooked biopexel_site_branding -  10
	 * @hooked biopexel_header_start -  20
	 * @hooked biopexel_site_navigation -  30
	 * @hooked biopexel_header_end -  50
	 *
	 */
	do_action( 'biopexel_header_action' );

	/**
	 * biopexel_content_start_action hook
	 *
	 * @hooked biopexel_content_start -  10
	 *
	 */
	do_action( 'biopexel_content_start_action' );

    /**
     * biopexel_header_image_action hook
     *
     * @hooked biopexel_header_image -  10
     *
     */
    do_action( 'biopexel_header_image_action' );
	
