<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php

	wp_title( '|', true, 'right' );
	bloginfo( 'name' );

?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php echo get_stylesheet_uri(); ?>" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

<?php
if ( is_singular() && get_option( 'thread_comments' ) )
	wp_enqueue_script( 'comment-reply' );
	
wp_head();
?>

</head>

<body <?php body_class(); ?>>

 <div id="wrapper">  

	<div id="header" style="background: url(<?php header_image(); ?>) no-repeat transparent;">
		<div id="header-left">	
			<?php if ( is_home() && !is_paged() ) { ?>
			<h1 id="site-title"><?php bloginfo( 'name' ); ?></h1>
			<?php } else { ?>
			<h2 id="site-title"><a href="<?php echo home_url(); ?>/"><?php bloginfo( 'name' ); ?></a></h2>
			<?php } ?>
			<p class="description"><?php bloginfo( 'description' ); ?></p>
		</div>
		<div id="header-right">
			<?php if( function_exists( 'wp_nav_menu' ) ) {
				wp_nav_menu( array( 'container_class' => 'header-menu', 'theme_location' => 'header', 'link_after' => ' /', 'fallback_cb' => false  ) ); 
			} ?>		
			<?php get_search_form(); ?>
		</div>

	</div>

	<div id="nav">
		<?php if( function_exists( 'wp_nav_menu' ) ) {
			wp_nav_menu( array('container_class' => 'main-menu', 'theme_location' => 'primary' ) ); 
		} else {
			wp_list_pages();
		} ?>
	</div>
	
	<div id="container">  
	