<?php
require_once( TEMPLATEPATH.'/core/init.php' );

add_editor_style('editor-styles.css');

if ( ! isset( $content_width ) )
	$content_width = 595;

// post thumbnail sizes registered throught the site.
add_image_size( 'home-featured', 260, 175, true );
add_image_size( 'home-featured-small', 65, 44, true );
add_image_size( 'post-thumb', 175, 118, true );
add_image_size( 'archive-post-thumb', 120, 81, true );
add_image_size( 'related-post-thumb', 160, 108, true );


if ( function_exists( 'register_nav_menus' ) ) {
	register_nav_menus( array(
		  'primary' => 'This is the Primary Navigation below the header.',
		  'footer'  => 'Footer menu',
		  'header'  => 'Header menu (above the search bar)'
	));
}

billions_register_sidebar( array(
	'name'		  =>'Primary Sidebar',
	'description' => __('This is the primary sidebar', 'billions'),
	'id' 		  => 'sidebar',
));
billions_register_sidebar( array(
	'name'		  =>'Footer Left',
	'description' => __('This is the primary sidebar', 'billions'),
	'id' 		  => 'sidebar-fl',
));
billions_register_sidebar( array(
	'name'		  =>'Footer Middle Left',
	'description' => __('This is the primary sidebar', 'billions'),
	'id' 		  => 'sidebar-fml',
));
billions_register_sidebar( array(
	'name'		  =>'Footer Middle Right',
	'description' => __('This is the primary sidebar', 'billions'),
	'id'		  => 'sidebar-fmr',
));
billions_register_sidebar( array(
	'name'		  =>'Footer Right',
	'description' => __('This is the primary sidebar', 'billions'),
	'id' 		  => 'sidebar-fr',
));
billions_register_sidebar( array(
	'name'		  =>'Home Bottom Right',
	'description' => __('This is the area to the right of "More News" on the hompage.- Great place for an 300x250 ad.', 'billions'),
	'id' 		  => 'sidebar-hbr',
));
billions_register_sidebar( array(
	'name'		  =>'Top Sidebar',
	'description' => __('This is the area is right above the primary sidebar. - Great place for an 300x250 ad.', 'billions'),
	'id' 		  => 'sidebar-ts',
));
add_filter( 'get_search_form', 'my_search_form' );
function my_search_form( $form ) {

    $form = '<form role="search" method="get" id="searchform" action="' . home_url( '/' ) . '" >
    <div>
    <input type="text" value="' . get_search_query() . '" name="s" id="s" />
    <input type="submit" id="searchsubmit" value="'. esc_attr__( 'Search' ) .'" />
    </div>
    </form>';

    return $form;
}

function billions_cat_name( $link = true ) {
	foreach( ( get_the_category() ) as $category ) { 
 
    $catID      = $category->cat_ID;
    $cat_name   = $category->cat_name; 
    $cat_slug   = $category->category_nicename; 
    $cat_desc   = $category->category_description; 
    $cat_parent = $category->category_parent;
    $cat_count  = $category->category_count;
    
    if ( $link = true ) : return '<a title="' . $cat_name . '" href="' . get_category_link($catID) . '">' . $cat_name . '</a>';
    else : return $cat_name;
    endif;
    }
    
} 

function billions_cat_feed_link() {
 	
    $cat_name       = single_cat_title( '', false );
    $category_id    = get_cat_ID( $cat_name );

    // Get the URL of this category
    $category_link  = get_category_link( $category_id );
    $category_link .= "/?feed=rss";
    
    return  $category_link;
}

function billions_byline( $authlink = true ) { ?>

	<div class="byline">
	
		 <?php if ( $authlink = true ) { ?> 
			 By <?php the_author_posts_link() ?> 
		 <?php } ?> 
		 	on <time datetime="<?php the_time( 'c' ); ?>"><?php the_time( 'l, F j, Y' ); ?></time>		 	
		 <?php edit_post_link( '(Edit)' ); ?> 
		 
	</div>
	
<?php }

add_filter( 'the_excerpt', 'add_read_more' );
function add_read_more( $content ) {
	if ( !is_home() ) {
		$string		 = $content;
		$pattern 	 = '</p>$';
		$replacement = '<span class="readmore"><a href="' . get_permalink() . '">read more</a></span></p>';
		$content 	 =  str_replace( $pattern, $replacement, $string );
	}
	return $content;
}


add_filter( 'wp_nav_menu_items', 'billions_date_menu_item', 10, 2 );
function billions_date_menu_item( $items, $args ) {
 	if( $args->theme_location == 'primary' ) {
		$homelink = '<li class="menu-item right date">' . get_the_time( 'l, F j, Y' ) . '</li>';
		$items =  $items . $homelink;
	}
	return $items;
}

add_shortcode( 'share', 'billions_sharin_shortcode' );
function billions_sharin_shortcode( $args ) {
   extract( shortcode_atts( array(
      ), $args ) );
 
   return '<span class="article-share">
		<span class="module-title">Share This</span>
		<span class="share-item">
			<a href="http://twitter.com/share" class="twitter-share-button" data-count="horizontal">Tweet</a><script type="text/javascript" src="http://platform.twitter.com/widgets.js"></script>
		</span>
		<span class="share-item">
			<a class="Digg" href="http://digg.com/submit?url=' . get_permalink() . '"><img src="http://widgets.digg.com/img/button/diggThisDigger.png" alt="Digg Button" title="Digg Button" class="thumbnail-digg-btn" /> Digg</a>
		</span>
		<span class="share-item">
			<a class="stumbleupon" href="http://www.stumbleupon.com/submit?url=' . get_permalink() . '&amp;title=' . urlencode( get_the_title() ) . '"><img src="http://www.stumbleupon.com/images/stumbleit.gif" /> Stumbleupon</a>
		</span>
		<span class="share-item">
			<a target="_blank" href="http://www.facebook.com/sharer.php?u=' . get_permalink() . '&amp;t=' . urlencode( get_the_title() ) .'"><img src="http://static.ak.fbcdn.net/images/connect_favicon.png" /> Facebook</a>
		</span>
		<span class="share-item">
			<a href="http://reddit.com/submit?url=' . get_permalink() . '&amp;title=' . urlencode( get_the_title() ) .'" rel="nofollow" target="_blank"><img src="http://www.reddit.com/static/spreddit5.gif" /> Reddit</a>
		</span>		
		<span class="share-item">
			<a href="http://www.google.com/reader/link?title=' . urlencode( get_the_title() ) . '&amp;url=' . get_permalink() . '" target="_blank"><img src="http://code.google.com/apis/buzz/images/google-buzz-16x16.png" /> Buzz</a>
		</span>
	</span>';
}

function billions_pagination( $pages = '', $range = 4) {
	$showitems = ( $range * 2 )+1;  
 
	global $paged;
	if( empty( $paged ) ) $paged = 1;
 
	if( $pages == '' ) {
		global $wp_query;
		$pages = $wp_query->max_num_pages;
		if( !$pages ) {
			$pages = 1;
		}
	}   
 
	if( 1 != $pages ) {
		echo '<div class="pagination">';
			if ( $paged > 2 )
				echo '<a href="' . get_pagenum_link( 1 ) . '">&#9664;&#9664;</a>';
			if ( get_previous_posts_link() )
				echo get_previous_posts_link( '&#9664' );
		
		echo '<span>Page ' . $paged . ' of ' . $pages . '</span>';
 
		for ( $i = 1; $i <= $pages; $i++ ) {
			if ( 1 != $pages && ( !( $i >= $paged+$range+1 || $i <= $paged-$range-1 ) || $pages <= $showitems ) ) {
				if ( $paged == $i ) { 
					echo '<span class="current">' . $i . '</span>';
				} else {
					echo '<a href="' . get_pagenum_link( $i ) . '" class="inactive">' . $i . '</a>';
				}
			}
		}
 		//	Next Post Link
		if ( get_next_posts_link() )
			echo get_next_posts_link( '&#9654' );
		if ($paged < $pages-1)
			echo '<a href="' . get_pagenum_link( $pages ) . '">&#9654;&#9654;</a>';
		
		echo '</div>';
	}
}

add_filter( 'get_comments_number', 'billions_separate_comment_count', 0 );
function billions_separate_comment_count( $id, $type = "comment" ) {
    global $id;
    $comments_by_type = &separate_comments( get_comments( 'post_id=' . $id ) );
    return count( $comments_by_type[$type] );
}

//function to get next or previous keys in an array
function billions_array_navigate( $array, $key ) {
	$keys 	= array_keys( $array);
	$index 	= array_flip( $keys) ;
	$return = array();
	$return['prev'] = ( isset( $keys[$index[$key]-1] ) ) ? $keys[$index[$key]-1] : end( $keys );
	$return['next'] = ( isset( $keys[$index[$key]+1] ) ) ? $keys[$index[$key]+1] : current( $keys );
	return $return;
}

//previous attachment link function
function billions_prev_att_link() {
global $post;
$post = get_post( $post );
//get the attachments which share the same post parent
$images =& get_children('post_type=attachment&post_mime_type=image&output=ARRAY_N&orderby=menu_order&order=ASC&post_parent='.$post->post_parent);
	
	if ( $images ) {
		//get the id of the previous attachment
		$ppid_arr = billions_array_navigate( $images, $post->ID );
		$ppid = $ppid_arr['prev'];
		foreach( $images as $key => $value ) {
			if( $key == $ppid ) {
				$output = '<a href="' . get_attachment_link( $value->ID ) . '">&laquo; Previous</a>';
			}
		}
		
		return $output;
	
	} else {
		//there is no previous link
		return false;
	}
}

//next attachment link function
function billions_next_att_link(){
global $post;
$post = get_post($post);
//get the attachments which share the same post parent
$images =& get_children('post_type=attachment&post_mime_type=image&output=ARRAY_N&orderby=menu_order&order=ASC&post_parent='.$post->post_parent);

	if ( $images ) {
		//get the id of the next attachment
		$ppid_arr = billions_array_navigate( $images, $post->ID) ;
		$ppid = $ppid_arr['next'];
		foreach( $images as $key => $value ) {
			if( $key == $ppid ) {
				$output = '<a href="' . get_attachment_link( $value->ID ) . '">Next &raquo;</a>';
			}
		}
		
		return $output;
		
	} else {
		//there is no next link
		return false;
	}
}

?>