<?php
add_action( 'admin_menu', 'billions_theme_menu' );

//theme menu option
function billions_theme_menu() {

  add_theme_page( 'Billions Theme Options', 'Billions Theme Options', 'edit_theme_options', 'billions-theme', 'billions_theme_options' );

}

//theme settings page
function billions_theme_options() {

    if ( !current_user_can( 'manage_options' ) )  {
    wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
    }

    ?>
    <div class="wrap">
	<h2><?php _e( 'Billions Theme Settings', 'billions-theme' ); ?></h2>
	<form method="post" action="options.php">
	    <?php settings_fields( 'billions_theme_options' ); ?>
	    <?php $options = get_option( 'b_theme_options' ); ?>
	    
	    <table class="form-table">
	    <tr valign="top">
		<th scope="row"><label for="bname"><?php _e( 'Twitter URL', 'billions-theme' ); ?></label></th>
		<td><input maxlength="45" size="45" name="b_theme_options[twitter_url]" value="<?php echo esc_url( $options['twitter_url'] ); ?>" /> ex: http://twitter.com/example</td>
	    </tr>
	    <tr valign="top">
		<th scope="row"><label for="bname"><?php _e( 'Facebook URL', 'billions-theme' ); ?></label></th>
		<td><input maxlength="45" size="45" name="b_theme_options[facebook_url]" value="<?php echo esc_url( $options['facebook_url'] ); ?>" /> ex: http://facebook.com/example</td>
	    </tr>
	    <tr valign="top">
		<th scope="row"><label for="bname"><?php _e( 'RSS URL', 'billions-theme' ); ?></label></th>
		<td><input maxlength="45" size="45" name="b_theme_options[rss_url]" value="<?php echo esc_url( $options['rss_url'] ); ?>" /> default: <?php echo get_bloginfo( 'rss2_url' ); ?></td>
	    </tr>
	  	<tr valign="top">
		<th scope="row"><label for="enable-share"><?php _e( 'Enable Sharing box on posts?', 'billions-theme' ); ?></label></th>
		<td><input <?php checked( absint( $options['enable_share'] ), 1 ); ?> type="checkbox" name="b_theme_options[enable_share]" value="1" /> Yes</td>
		</tr>
	    <tr valign="top">
		<td>
		<input type="submit" name="save" value="Save Settings" class="button-primary" />
		</td>
	    </tr>
	    </table>
	</form>
	</div>
    <?php
}

add_action( 'admin_init', 'billions_settings_init' );

function billions_settings_init() {

	register_setting( 'billions_theme_options', 'b_theme_options', 'b_theme_options_validate' );

}

function b_theme_options_validate( $input ) {

	$input['twitter_url'] = esc_url( $input['twitter_url'] );
	$input['facebook_url'] = esc_url( $input['facebook_url'] );
	$input['rss_url'] = esc_url( $input['rss_url'] );
	if ( !isset( $input['enable_share'] ) )
		$input['enable_share'] = null;
	$input['enable_share'] = ( $input['enable_share'] == 1 ? 1 : 0 );

	return $input;

}