<?php 
load_theme_textdomain( 'billions' );

add_custom_background();

add_theme_support( 'menus' );
add_theme_support( 'post-thumbnails' );
add_theme_support( 'automatic-feed-links' );

//include theme plugins

//verify Add Meta Tags plugin doesn't exist before including
if ( !function_exists( 'amt_options_page' ) ) {
    include_once( 'plugins/seo-features.php' );
}

//verify Yoast Breadcrumbs plugin doesn't exist before including
if ( !class_exists( 'YoastBreadcrumbs_Admin' ) ) {
    include_once( 'plugins/breadcrumbs/yoast-breadcrumbs.php' );
}

// Set some default structure to our widget areas.
function billions_register_sidebar( $args ) {
	$defaults = array(
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => "</div>\n",
		'before_title'  => '<h4 class="widgettitle">',
		'after_title'   => "</h4>\n"
	);

	$args = wp_parse_args( $args, $defaults );

	return register_sidebar( $args );
}

define( 'BILLIONS_CORE_DIR', TEMPLATEPATH.'/core' );
define( 'BILLIONS_FUNCTIONS_DIR', BILLIONS_CORE_DIR.'/functions' );


require_once( BILLIONS_CORE_DIR .'/custom-header.php' );
require_once( BILLIONS_CORE_DIR .'/settings.php' );