<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Canyon Themes
 * @subpackage Better Health
 */
$better_health_breadcrump_option = better_health_get_option('better_health_breadcrumb_setting_option');
$better_health_designlayout = better_health_get_option('better_health_sidebar_layout_option');
$sidebar_primary_classes_alignment =  ' col-lg-9 ' ;
if ( $better_health_designlayout == 'left-sidebar') { 
	$sidebar_primary_classes_alignment =  ' col-lg-9 order-lg-2' ;
}
get_header(); ?>
    <section id="inner-title" class="inner-title"  <?php echo $header_style; ?>>
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h2><?php printf(esc_html__('Search Results for: %s', 'better-health'), '<span>' . get_search_query() . '</span>'); ?></h2>
                </div>
                <?php if ($better_health_breadcrump_option == "enable") {
                    ?>
                    <div class="col-md-4">
                        <div class="breadcrumbs">
                            <?php breadcrumb_trail(); ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </section>
    <section id="section16" class="section16">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 <?php echo $sidebar_primary_classes_alignment; ?> left-block">
                    <?php
                    if (have_posts()) : ?>

                        <?php
                        /* Start the Loop */
                        while (have_posts()) : the_post();

                            /**
                             * Run the loop for the search to output the results.
                             * If you want to overload this in a child theme then include a file
                             * called content-search.php and that will be used instead.
                             */
                            get_template_part('template-parts/content', 'search');

                        endwhile;

                        the_posts_navigation();

                    else :

                        get_template_part('template-parts/content', 'none');

                    endif; ?>

                </div><!-- div -->
                 <?php 
				$sidebar_classes_alignment =  '' ;
				if ( $better_health_designlayout == 'left-sidebar') { 
					  $sidebar_classes_alignment =  'order-lg-1' ;
					 
					 }                     
				if ($better_health_designlayout != 'no-sidebar') { ?>
                    <div class="col-md-12 col-sm-12 col-lg-3 <?php echo $sidebar_classes_alignment; ?>">
                        <?php get_sidebar(); ?>
                    </div>
                <?php } ?><!--end of if -->
            </div><!-- div -->
        </div>
    </section>

<?php get_footer();
