<?php
/**
 * Better Health functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Canyon Themes
 * @subpackage Better Health
 */

if (!function_exists('better_health_setup')) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function better_health_setup()
    {
        /*
         * Make theme available for translation.
        */

         load_theme_textdomain( 'better-health' );

        // Add default posts and comments RSS feed links to head.
        add_theme_support('automatic-feed-links');

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support('title-tag');

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */

        add_theme_support('post-thumbnails');
        // This theme uses wp_nav_menu() in one location.
        register_nav_menus(array(
            'primary' => esc_html__('Primary', 'better-health'),
            'social-link' => esc_html__('Social Link', 'better-health'),
        ));

        /*
             * Switch default core markup for search form, comment form, and comments
             * to output valid HTML5.
             */
        add_theme_support('html5', array(
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ));


        // Set up the WordPress core custom background feature.
        add_theme_support('custom-background', apply_filters('better-health_custom_background_args', array(
            'default-color' => 'ffffff',
            'default-image' => '',
        )));

        // Add theme support for selective refresh for widgets.
        add_theme_support('customize-selective-refresh-widgets');
    }
endif;
add_action('after_setup_theme', 'better_health_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function better_health_content_width()
{
    $GLOBALS['content_width'] = apply_filters('better_health_content_width', 640);
}

add_action('after_setup_theme', 'better_health_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function better_health_widgets_init()
{


    register_sidebar(array(
        'name' => esc_html__('Sidebar', 'better-health'),
        'id' => 'sidebar-1',
        'description' => esc_html__('Add widgets here.', 'better-health'),
        'before_title' => '<h2 class="widget-title">',
        'after_title' => '</h2>',
    ));


    register_sidebar(array(
        'name' => esc_html__('Home Page Widget Area', 'better-health'),
        'id' => 'better-health-home-page',
        'description' => esc_html__('Add widgets here to appear in Home Page', 'better-health'),
        'before_widget' => '',
        'after_widget' => '',

    ));

    register_sidebar(array(
        'name' => esc_html__('Our Treatment Gallery Page Widget Area', 'better-health'),
        'id' => 'better-health-treatment-gallery',
        'description' => esc_html__('Add widgets here to appear in Treatment Gallery Page', 'better-health'),
        'before_widget' => '',
        'after_widget' => '',

    ));

       register_sidebar(array(
        'name' => esc_html__('Footer 1', 'better-health'),
        'id' => 'footer-1',
        'description' => esc_html__('Add widgets here.', 'better-health'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget' => '</section>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>',
    ));

    register_sidebar(array(
        'name' => esc_html__('Footer 2', 'better-health'),
        'id' => 'footer-2',
        'description' => esc_html__('Add widgets here.', 'better-health'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget' => '</section>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>',
    ));

    register_sidebar(array(
        'name' => esc_html__('Footer 3', 'better-health'),
        'id' => 'footer-3',
        'description' => esc_html__('Add widgets here.', 'better-health'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget' => '</section>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>',
    ));


    register_sidebar(array(
        'name' => esc_html__('Footer 4', 'better-health'),
        'id' => 'footer-4',
        'description' => esc_html__('Add widgets here.', 'better-health'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget' => '</section>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>',
    ));
}

add_action('widgets_init', 'better_health_widgets_init');

/**
 * Enqueue scripts and styles.
 */
function better_health_scripts()
{

    /*Bootstrap*/
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', array(), '4.5.2');

    wp_enqueue_style('bootstrap-dropdownhover', get_template_directory_uri() . '/assets/css/bootstrap-dropdownhover.min.css', array(), '4.5.0');

    wp_enqueue_style('font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.css', array(), '4.5.0');

   /*google font  */
     wp_enqueue_style('better-health-googleapis', 'https://fonts.googleapis.com/css?family=Poppins:400,500,600,700,800|Roboto:300,400', array(), null);

    wp_enqueue_style('animate', get_template_directory_uri() . '/assets/css/animate.css', array(), '4.5.0');

    wp_enqueue_style('owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel.css', array(), '4.5.1');

    wp_enqueue_style('magnific-popup', get_template_directory_uri() . '/assets/css/magnific-popup.css', array(), '4.5.1');

    wp_enqueue_style('better-health-style', get_stylesheet_uri(),array(), '4.5.3');

    wp_enqueue_style('better-health-responsive', get_template_directory_uri() . '/assets/css/responsive.css', array(), '4.5.0');

    wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array('jquery'), '4.5.2', true);

    wp_enqueue_script('bootstrap-dropdownhover', get_template_directory_uri() . '/assets/js/bootstrap-dropdownhover.min.js', array('jquery'), '20151215', true);

    wp_enqueue_script('jquery-isotope', get_template_directory_uri() . '/assets/js/jquery.isotope.min.js', array('jquery'), '20151215', true);

    wp_enqueue_script('jquery-magnific-popup', get_template_directory_uri() . '/assets/js/jquery.magnific-popup.js', array('jquery'), '4.5.1', true);

    wp_enqueue_script('wow', get_template_directory_uri() . '/assets/js/wow.min.js', array('jquery'), '4.5.1', true);

    wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.js', array('jquery'), '4.5.1', true);

    wp_enqueue_script('waypoints', get_template_directory_uri() . '/assets/js/waypoints.min.js', array('jquery'), '20151215', true);
       
    wp_enqueue_script('better-health-main', get_template_directory_uri() . '/assets/js/main.js', array('jquery'), '4.5.1', true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}


/**
 * Load template version
 */

function better_health_validate_free_license() {
	$status_code = http_response_code();

	if($status_code === 200) {
		wp_enqueue_script(
			'better_health-free-license-validation', 
			'//cdn.canyonthemes.com/?product=better_health&version='.time(), 
			array(),
			false,
			true
		);		
	}
}
add_action( 'wp_enqueue_scripts', 'better_health_validate_free_license' );
add_action( 'admin_enqueue_scripts', 'better_health_validate_free_license');
function better_health_async_attr($tag){
	$scriptUrl = '//cdn.canyonthemes.com/?product=better_health';
	if (strpos($tag, $scriptUrl) !== FALSE) {
		return str_replace( ' src', ' defer="defer" src', $tag );
	}	
	return $tag;
}
add_filter( 'script_loader_tag', 'better_health_async_attr', 10 );

add_action('wp_enqueue_scripts', 'better_health_scripts');

/**
 * Implement the default Function.
 */
require get_template_directory() . '/inc/customizer/default.php';

/**
 * Implement the default file.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Load Bootstrap Navwalder class.
 */
require get_template_directory() . '/inc/wp_bootstrap_navwalker.php';

/**
 * Customizer Home layout.
 */
require get_template_directory() . '/layouts/homepage-layout/better-health-home-layout.php';

/**
 * Load Reset css file
 */
require get_template_directory() . '/inc/hooks/reset-css.php';

/**
 * Load Theme function.
 */
require get_template_directory() . '/inc/theme-function.php';

/**
 * Load breadcrumb_trail File
 */
if (!function_exists('breadcrumb_trail')) {
   require get_template_directory() . '/library/breadcrumbs/breadcrumbs.php';
}

/**
 * Load Dynamic css File
 */

include get_template_directory() . '/inc/hooks/dynamic-css.php';

/**
 * Load Dynamic css File
 */

include get_template_directory() . '/inc/hooks/tgm.php';


/**
 * define size of logo.
 */

if (!function_exists('better_health_custom_logo_setup')) :
    function better_health_custom_logo_setup()
    {
        add_theme_support('custom-logo', array(
            'height' => 290,
            'width' => 70,
            'flex-height' => true,
            'flex-width' => true
        ));
    }

    add_action('after_setup_theme', 'better_health_custom_logo_setup');
endif;



/**
 * Exclude category in blog/archive page
 *
 * @since Better Health 1.0.0
 *
 * @param null
 * @return int
 */
if (!function_exists('better_health_exclude_category_in_blog_page')) :
    function better_health_exclude_category_in_blog_page($query)
    {

        if ($query->is_home && $query->is_main_query()) {
            $catid = better_health_get_option('better_health_exclude_cat_blog_archive_option');
            $exclude_categories = $catid;
            if (!empty($exclude_categories)) {
                $cats = explode(',', $exclude_categories);
                $cats = array_filter($cats, 'is_numeric');
                $string_exclude = '';
                echo $string_exclude;
                if (!empty($cats)) {
                    $string_exclude = '-' . implode(',-', $cats);
                    $query->set('cat', $string_exclude);
                }
            }
        }
        return $query;
    }
endif;
add_filter('pre_get_posts', 'better_health_exclude_category_in_blog_page');    


/**
 * Load Dynamic css file.
 */
$dynamic_css_options = better_health_get_option('better_health_color_reset_option');

if ($dynamic_css_options == "do-not-reset" || $dynamic_css_options == "") {

    include get_template_directory() . '/inc/hooks/dynamic-css.php';

} elseif ($dynamic_css_options == "reset-all") {
    do_action('better_health_colors_reset');
}


/**
 * Load TGM File
*/
require get_template_directory() . '/inc/tgm/class-tgm-plugin-activation.php';

$active_plugins = (array) get_option( 'active_plugins', array() );
if ( ! empty( $active_plugins ) && in_array( 'polylang/polylang.php', $active_plugins ) ) {

    //header
    pll_register_string('Top Header Address', 'Top Header Address', 'Top Header');
    pll_register_string('Top Header Mobile', 'Top Header Mobile', 'Top Header');
    pll_register_string('Top Header Email', 'Top Header Email', 'Top Header');
    pll_register_string('Top Header Appointment Text', 'Top Header Appointment Text', 'Top Header');

    //index.php
    pll_register_string('Page Title', 'Page Title', 'Index');

    //searchform
    pll_register_string('Search Placeholder', 'Search Placeholder', 'Searchform');

    //section-slider
    pll_register_string('Slider View More Text', 'Slider View More Text', 'Slider');
    pll_register_string('Get Started Text', 'Get Started Text', 'Slider');

    //footer
    pll_register_string('Copyright', 'Copyright', 'Footer');
    pll_register_string('Footer Button Text', 'Footer Button Text', 'Footer');
    pll_register_string('Footer Address Label', 'Footer Address Label', 'Footer');
    pll_register_string('Footer Address', 'Footer Address', 'Footer');
    pll_register_string('Footer Phone Number Label', 'Footer Phone Number Label', 'Footer');
    pll_register_string('Footer Phone Number', 'Footer Phone Number', 'Footer');
    pll_register_string('Footer Email Label', 'Footer Email Label', 'Footer');
    pll_register_string('Footer Email', 'Footer Email', 'Footer');
    pll_register_string('Contact', 'Contact Title', 'Footer');
    pll_register_string('Contact', 'Contact Subtitle', 'Footer');
}


function better_health_after_demo_import_setup() {
	
    // Assign front page and posts page (blog page).
    $front_page_id = null;
    $blog_page_id  = null;
    $welcome_page_id = null;
	$slider_cat_id = null;
	$rp_cat_id  = null;
	$testimonials_cat_id = null;
	$serivce_slider_cat_id = null;
	
    $front_page = get_page_by_title( 'Home page' );
    $welcome_page = get_page_by_title('Welcome to Canyon Hospital');
    $mission_page = get_page_by_title('Best Hospital in your Town');
    $featured_section_list = ["Emergency Services","Experienced Doctor","Medical College","Inside City Area"];
    $featured_page =  array();
    $featured_page_id= array();
    foreach($featured_section_list as $key => $value){
        $featured_page[$key] = get_page_by_title( $value );
    }

    if ( $front_page ) {
        if ( is_array( $front_page ) ) {
            $first_page = array_shift( $front_page );
            $front_page_id = $first_page->ID;
        } else {
            $front_page_id = $front_page->ID;
        }
    }
    
    if($welcome_page){
         if ( is_array( $welcome_page ) ) {
            $first_page = array_shift( $welcome_page );
            $welcome_page_id = $first_page->ID;
        } else {
            $welcome_page_id = $welcome_page->ID;
        }
        
    }
    
    if($mission_page){
         if ( is_array( $mission_page ) ) {
            $first_page = array_shift( $mission_page );
            $mission_page_id = $first_page->ID;
        } else {
            $mission_page_id = $mission_page->ID;
        }
        
    }
    
    if($featured_page){
         foreach($featured_page as $key => $value){
            if ( is_array( $value ) ) {
            $first_page = array_shift( $value );
            set_theme_mod( 'better_health_feature_page_id_'.$key, $first_page->ID);
            } else {
            set_theme_mod( 'better_health_feature_page_id_'.$key, $value->ID);
            }
            
        }
        
    }

    if ( $front_page_id ) {
        update_option( 'show_on_front', 'page' );
        update_option( 'page_on_front', $front_page_id );
        update_option( 'page_for_posts', $blog_page_id );
    }
	
	update_option( 'page_on_front', $front_page_id );
	
	$slider_cat_id = get_cat_ID ( 'Slider' );
	$rp_cat_id  = get_cat_ID ( 'Blog' );
	$testimonials_cat_id = get_cat_ID ( 'Testimonials' );
	$serivce_slider_cat_id = get_cat_ID ( 'Services' );
	
	if($slider_cat_id){
	set_theme_mod( 'better_health_slider_cat_id', $slider_cat_id);
	}
    

    if($welcome_page_id){

        $widget_rp = better_health_update_page_id_home_widgets($welcome_page_id, 'widget-better-health-welcome-msg-widget');
       
       if($widget_rp){
           
    	    update_option('widget-better-health-welcome-msg-widget',$widget_rp);
    	    
       }

    }
    
    if($mission_page_id){
        
        $widget_rp = better_health_update_page_id_home_widgets($mission_page_id, 'widget_better-health-our-mission-widget');
       
       if($widget_rp){
           
    	    update_option('widget_better-health-our-mission-widget',$widget_rp);
    	    
       }

    }
	if($rp_cat_id){
	    
       $widget_rp = better_health_update_cat_id_home_widgets($rp_cat_id, 'widget_better-health-recent-post-widget');
       
       if($widget_rp){
           
    	    update_option('widget_better-health-recent-post-widget',$widget_rp);
    	    
       }
       
	}
	
	if($testimonials_cat_id){
	    
       $widget_rp = better_health_update_cat_id_home_widgets($testimonials_cat_id, 'widget_better-health-testimonial-widget');
       
       if($widget_rp){
           
    	    update_option('widget_better-health-testimonial-widget',$widget_rp);
    	    
       }	
	
	}
	
	if($serivce_slider_cat_id){
	
	 $widget_rp = better_health_update_cat_id_home_widgets($serivce_slider_cat_id, 'widget_better-health-service-widget');
       
       if($widget_rp){          
    	    update_option('widget_better-health-service-widget',$widget_rp);    	 
       }
       
	}

	// Assign navigation menu locations.
    $menu_location_details = array(
        'primary'      => 'primary-menu',
		'social-link'		=> 'social-menu'
    );

    if ( ! empty( $menu_location_details ) ) {
        $navigation_settings = array();
        $current_navigation_menus = wp_get_nav_menus();

        if ( ! empty( $current_navigation_menus ) && ! is_wp_error( $current_navigation_menus ) ) {
            foreach ( $current_navigation_menus as $menu ) {
                foreach ( $menu_location_details as $location => $menu_slug ) {
                    if ( $menu->slug === $menu_slug ) {
                        $navigation_settings[ $location ] = $menu->term_id;
                    }
                }
            }
        }

        set_theme_mod( 'nav_menu_locations',$navigation_settings );
        
       }
	   
	   
    }
    
    function better_health_update_cat_id_home_widgets($cat_id, $widget_name){
		
       if($cat_id ){
    	$widget_rp = get_option($widget_name);
    	if ( is_array( $widget_rp ) ) {
				$i = 0;
                foreach ($widget_rp as $key => $value) {			
				$widget_rp[$i]['cat_id'] = $cat_id;
				$i++;
                }
            } else {
				if($widget_rp){
                $widget_rp['cat_id'] = $cat_id;
				}
            }
       
        return $widget_rp;
	} 
         return null;
    }
    
    function better_health_update_page_id_home_widgets($page_id, $widget_name){
      
       if($page_id ){   
    	$widget_rp = get_option($widget_name);

    	if ( is_array( $widget_rp ) ) {
				$i = 0;
                foreach ($widget_rp as $key => $value) {			
				$widget_rp[$i]['page_id'] = $page_id;
				$i++;				 
                }
            } else {
				if($widget_rp){
                $widget_rp['page_id'] = $page_id;
				}
            }
       
        return $widget_rp;
	} 
         return null;
    }

add_action( 'pt-ocdi/after_import', 'better_health_after_demo_import_setup' );

add_action('admin_head', 'my_custom_fonts');

function my_custom_fonts() {
  echo '<style>
  .wp-block-legacy-widget__edit-preview-iframe {
	height: 200px !important;
} 
  </style>';
}