<?php
/**
 * Recommended way to include parent theme styles.
 * (Please see http://codex.wordpress.org/Child_Themes#How_to_Create_a_Child_Theme)
 */

add_action( 'wp_enqueue_scripts', 'betra_style' );
function betra_style() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'parent-style' ) );
}

/**
 * Add editor styles to match the theme's frontend.
 */
add_action( 'after_setup_theme', 'betra_editor_style' );
function betra_editor_style() {
    add_editor_style( 'editor-style.css' );
}

/**
 * Load theme text domain.
 */
add_action( 'after_setup_theme', 'betra_load_textdomain' );
function betra_load_textdomain() {
    load_theme_textdomain( 'betra', get_template_directory() . '/languages' );
}

/**
 * Your code goes below.
 */
 function betra_theme_custom_header_setup() {
    $args = array(
        'default-text-color'     => '000', // Default text color
        'width'                  => 1000, // Width of the header image
        'height'                 => 250, // Height of the header image
        'flex-height'            => true, // Enable flexible height for header image
        'flex-width'             => true, // Enable flexible width for header image
    );

    add_theme_support( 'custom-header', $args );
}
add_action( 'after_setup_theme', 'betra_theme_custom_header_setup' );

add_theme_support( 'title-tag' );
add_theme_support( 'automatic-feed-links' );
add_theme_support( 'wp-block-styles' );
add_theme_support( 'responsive-embeds' );
add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );
add_theme_support( 'custom-logo' );
add_theme_support( 'custom-background' );
add_theme_support( 'align-wide' );
add_theme_support( 'post-thumbnails' );
?>