<?php
/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package WordPress
 * @subpackage beonepage
 * @since Twenty Twenty-One 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since Twenty Twenty-One 1.0
	 *
	 * @return void
	 */
	function advocx_register_block_styles() {
		// Columns: Overlap.
		register_block_style(
			'core/columns',
			array(
				'name'  => 'beonepage-columns-overlap',
				'label' => esc_html__( 'Overlap', 'beonepage' ),
			)
		);

		// Cover: Borders.
		register_block_style(
			'core/cover',
			array(
				'name'  => 'beonepage-border',
				'label' => esc_html__( 'Borders', 'beonepage' ),
			)
		);

		// Group: Borders.
		register_block_style(
			'core/group',
			array(
				'name'  => 'beonepage-border',
				'label' => esc_html__( 'Borders', 'beonepage' ),
			)
		);

		// Image: Borders.
		register_block_style(
			'core/image',
			array(
				'name'  => 'beonepage-border',
				'label' => esc_html__( 'Borders', 'beonepage' ),
			)
		);

		// Image: Frame.
		register_block_style(
			'core/image',
			array(
				'name'  => 'beonepage-image-frame',
				'label' => esc_html__( 'Frame', 'beonepage' ),
			)
		);

		// Latest Posts: Dividers.
		register_block_style(
			'core/latest-posts',
			array(
				'name'  => 'beonepage-latest-posts-dividers',
				'label' => esc_html__( 'Dividers', 'beonepage' ),
			)
		);

		// Latest Posts: Borders.
		register_block_style(
			'core/latest-posts',
			array(
				'name'  => 'beonepage-latest-posts-borders',
				'label' => esc_html__( 'Borders', 'beonepage' ),
			)
		);

		// Media & Text: Borders.
		register_block_style(
			'core/media-text',
			array(
				'name'  => 'beonepage-border',
				'label' => esc_html__( 'Borders', 'beonepage' ),
			)
		);

		// Separator: Thick.
		register_block_style(
			'core/separator',
			array(
				'name'  => 'beonepage-separator-thick',
				'label' => esc_html__( 'Thick', 'beonepage' ),
			)
		);

		// Social icons: Dark gray color.
		register_block_style(
			'core/social-links',
			array(
				'name'  => 'beonepage-social-icons-color',
				'label' => esc_html__( 'Dark gray', 'beonepage' ),
			)
		);
	}
	add_action( 'init', 'advocx_register_block_styles' );
}
