<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

	
	$general_sticky_menu = (class_exists('Kirki') && !empty(Kirki::get_option('general_sticky_menu'))) ? Kirki::get_option('general_sticky_menu') : '1'; 
	$general_go_to_top = (class_exists('Kirki') && !empty(Kirki::get_option('general_go_to_top'))) ? Kirki::get_option('general_go_to_top') : '1';
	$blogdesc =  (class_exists('Kirki') && !empty(Kirki::get_option('blogdesc'))) ? Kirki::get_option('blogdesc') :get_bloginfo( 'description', 'display' ); 
	$front_page_text_slider_title = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_text_slider_title'))) ? Kirki::get_option('front_page_text_slider_title') : 'Be <span>Imaginative</span> &bull; Be <span>Yourself</span>'; 
	$front_page_text_slider_content = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_text_slider_content'))) ? Kirki::get_option('front_page_text_slider_content') : 'We handcraft well-thought-out WordPress themes'; 
	$front_page_text_slider_btn_text = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_text_slider_btn_text'))) ? Kirki::get_option('front_page_text_slider_btn_text') : 'Learn More';
	$front_page_text_slider_btn_url = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_text_slider_btn_url'))) ? Kirki::get_option('front_page_text_slider_btn_url') : 'http://betheme.me';
	$front_page_text_slider_bg = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_text_slider_bg'))) ? Kirki::get_option('front_page_text_slider_bg') : array('image'    => get_template_directory_uri() . '/images/background.jpg',
	'position' => 'center center',); 
	$front_page_text_slider_parallax = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_text_slider_parallax'))) ? Kirki::get_option('front_page_text_slider_parallax') : '1'; 
	$front_page_text_slider_scroll_down = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_text_slider_scroll_down'))) ? Kirki::get_option('front_page_text_slider_scroll_down') : '1'; 
	$front_page_icon_service_module_id = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_icon_service_module_id'))) ? Kirki::get_option('front_page_icon_service_module_id') : '1'; 
	$front_page_icon_service_module_id = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_icon_service_module_id'))) ? Kirki::get_option('front_page_icon_service_module_id') : 'icon-service-module'; 
	$front_page_icon_service_module_title = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_icon_service_module_title'))) ? Kirki::get_option('front_page_icon_service_module_title') : 'icon-service-module'; 
	$front_page_icon_service_module_title = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_icon_service_module_title'))) ? Kirki::get_option('front_page_icon_service_module_title') : 'Icon <span>Service</span> Module'; 
	$front_page_icon_service_module_subtitle = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_icon_service_module_subtitle'))) ? Kirki::get_option('front_page_icon_service_module_subtitle') : 'Subtitle for icon service module'; 
	$front_page_icon_service_module_layout = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_icon_service_module_layout'))) ? Kirki::get_option('front_page_icon_service_module_layout') : 'fixed'; 
	$front_page_portfolio_module_id = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_portfolio_module_id'))) ? Kirki::get_option('front_page_portfolio_module_id') : 'portfolio-module'; 
	$front_page_portfolio_module_title = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_portfolio_module_title'))) ? Kirki::get_option('front_page_portfolio_module_title') : 'Portfolio Module'; 
	$front_page_portfolio_module_subtitle = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_portfolio_module_subtitle'))) ? Kirki::get_option('front_page_portfolio_module_subtitle') : 'Portfolio Module'; 
	$front_page_portfolio_module_subtitle = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_portfolio_module_subtitle'))) ? Kirki::get_option('front_page_portfolio_module_subtitle') : 'Subtitle for portfolio module'; 
	$front_page_portfolio_module_filter = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_portfolio_module_filter'))) ? Kirki::get_option('front_page_portfolio_module_filter') : '1'; 
	$front_page_portfolio_module_all = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_portfolio_module_all'))) ? Kirki::get_option('front_page_portfolio_module_all') : 'Show All'; 
	$front_page_ver_promo_module_id = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_ver_promo_module_id'))) ? Kirki::get_option('front_page_ver_promo_module_id') : 'ver-promo-module'; 
	$front_page_ver_promo_title = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_ver_promo_title'))) ? Kirki::get_option('front_page_ver_promo_title') : 'We are <span>BeTheme</span>'; 
	$front_page_ver_promo_content = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_ver_promo_content'))) ? Kirki::get_option('front_page_ver_promo_content') : 'We build more than just Themes. We build User Experience for both, you and your visitors.'; 
	$front_page_ver_promo_btn_text = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_ver_promo_btn_text'))) ? Kirki::get_option('front_page_ver_promo_btn_text') : 'Learn More'; 
	$front_page_ver_promo_btn_url = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_ver_promo_btn_url'))) ? Kirki::get_option('front_page_ver_promo_btn_url') : 'http://betheme.me'; 
	$front_page_blog_module_id = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_blog_module_id'))) ? Kirki::get_option('front_page_blog_module_id') : 'blog-module'; 
	$front_page_blog_module_title = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_blog_module_title'))) ? Kirki::get_option('front_page_blog_module_title') : 'Blog Module'; 
	$front_page_blog_module_subtitle = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_blog_module_subtitle'))) ? Kirki::get_option('front_page_blog_module_subtitle') : 'Subtitle for blog module'; 
	$front_page_blog_module_read_more = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_blog_module_read_more'))) ? Kirki::get_option('front_page_blog_module_read_more') : 'Read More'; 
	$front_page_blog_module_view_more = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_blog_module_view_more'))) ? Kirki::get_option('front_page_blog_module_view_more') : 'View More'; 
	$front_page_contact_module_id = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_contact_module_id'))) ? Kirki::get_option('front_page_contact_module_id') : 'contact-module'; 
	$front_page_contact_module_title = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_contact_module_title'))) ? Kirki::get_option('front_page_contact_module_title') : '<span>Contact</span> Module'; 
	$front_page_contact_module_subtitle = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_contact_module_subtitle'))) ? Kirki::get_option('front_page_contact_module_subtitle') : 'Subtitle for contact module'; 
	$front_page_contact_module_send = (class_exists('Kirki') && !empty(Kirki::get_option('front_page_contact_module_send'))) ? Kirki::get_option('front_page_contact_module_send') : 'Send'; 
	$blog_page_header_bg = (class_exists('Kirki') && !empty(Kirki::get_option('blog_page_header_bg'))) ? Kirki::get_option('blog_page_header_bg') : array('background-image'    => ''.get_template_directory_uri() . '/images/header_bg.jpg','background-position' => 'center-center'); 
	$footer_copyright = (class_exists('Kirki') && !empty(Kirki::get_option('footer_copyright'))) ? Kirki::get_option('footer_copyright') : esc_html__( 'Copyrights &copy; 2017. All Rights Reserved.', 'beonepage'); 
	$footer_site_title = (class_exists('Kirki') && !empty(Kirki::get_option('footer_site_title'))) ? Kirki::get_option('footer_site_title') : '1'; 
	$upgrade_theme_info = (class_exists('Kirki') && !empty(Kirki::get_option('upgrade_theme_info'))) ? Kirki::get_option('upgrade_theme_info') : '<p>' . esc_html__( "Want to remove the theme byline from your website's footer?", 'beonepage' ) . '</p><p><i><a href="' . esc_url( 'http://betheme.me/themes/beonepage/' ) . '" target="_blank">' . esc_html__( 'Upgrade to BeOnePage Pro Now', 'beonepage' ) . '</a></i></p>'; 
	
	
	if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "redux_demo";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'redux_demo/opt_name', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */

    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();
    
    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme Options', 'beonepage' ),
        'page_title'           => __( 'Theme Options', 'beonepage' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => true,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'redux_demo',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    $args['admin_bar_links'][] = array(
        'id'    => 'redux-docs',
        'href'  => 'http://docs.reduxframework.com/',
        'title' => __( 'Documentation', 'beonepage' ),
    );

    $args['admin_bar_links'][] = array(
        //'id'    => 'redux-support',
        'href'  => 'https://github.com/ReduxFramework/redux-framework/issues',
        'title' => __( 'Support', 'beonepage' ),
    );

    $args['admin_bar_links'][] = array(
        'id'    => 'redux-extensions',
        'href'  => 'reduxframework.com/extensions',
        'title' => __( 'Extensions', 'beonepage' ),
    );

    // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
    $args['share_icons'][] = array(
        'url'   => 'https://github.com/ReduxFramework/ReduxFramework',
        'title' => 'Visit us on GitHub',
        'icon'  => 'el el-github'
        //'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/pages/Redux-Framework/243141545850368',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://twitter.com/reduxframework',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://www.linkedin.com/company/redux-framework',
        'title' => 'Find us on LinkedIn',
        'icon'  => 'el el-linkedin'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( '<p>Did you know that Redux sets a global variable for you? To access any of your saved options from within your code you can use your global variable: <strong>$%1$s</strong></p>', 'beonepage' ), $v );
    } else {
        $args['intro_text'] = __( '<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'beonepage' );
    }

    // Add content after the form.
    $args['footer_text'] = __( '<p>This text is displayed below the options panel. It isn\'t required, but more info is always better! The footer_text field accepts all HTML.</p>', 'beonepage' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


   
	/*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */

    // -> START Basic Fields
	$permalink_url = '<a href="'. admin_url() .'options-reading.php" target="_blank">here</a>';
	$general_front_page_url = 'Please click '.$permalink_url.' to set static front page';
	$general_post_page_url = 'Please click '.$permalink_url.' to set static Post page';
	/*  General Panel Start  */
	Redux::setSection( $opt_name, array(
        'title'            => __( 'General', 'beonepage' ),
        'id'               => 'site_general',
        'desc'             => __( 'These are really basic fields!', 'beonepage' ),
        'customizer_width' => '400px',
        'icon'             => 'el el-user',
		'fields'           => array(
            array(
                'id'       => 'general_sticky_menu',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Sticky Menu?', 'beonepage' ),
                'subtitle' => '',
                'desc'     => __( 'If enable, the menu will be accessible from anywhere without having to scroll.', 'beonepage' ),
                'default'  => $general_sticky_menu,
            ),
			 array(
                'id'       => 'general_go_to_top',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Go to Top Button?', 'beonepage' ),
                'subtitle' => '',
                'desc'     => '',
                'default'  => $general_go_to_top,
            ),
			array(
				'id'       		=> 'general_front_page',
				'type'     		=> 'raw',
				'title'    		=> __( 'Front Page', 'beonepage' ),
				'content'  		=> $general_front_page_url,
			),
			array(
				'id'      		=> 'general_posts_page',
				'type'     		=> 'raw',
				'title'    		=> __( 'Posts Page', 'beonepage' ),
				'content' 		=> $general_post_page_url,
			),
		)
    ) ); 
	/*  General Panel End 	*/
	/*	Site Identity Panel Start 	*/
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Site Identity', 'beonepage' ),
        'id'               => 'title_tagline',
        'desc'             => __( 'These are really basic fields!', 'beonepage' ),
        'customizer_width' => '400px',
        'icon'             => 'el el-edit',
		'fields'           => array(
           
			array(
                'id'       => 'blogdesc',
                'type'     => 'text',
                'title'    => __( 'Tagline', 'beonepage' ),
                'subtitle' => __( 'Subtitle', 'beonepage' ),
                'desc'     => __( 'Site Description', 'beonepage' ),
                'default'  => $blogdesc,
            ),
			

        )
    ) );
	/*	Site Identity Panel End	*/

	/*	Front Page Panel Start	*/
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Front Page', 'beonepage' ),
        'id'               => 'site_front_page',
        'desc'             => __( 'These are really basic fields!', 'beonepage' ),
        'customizer_width' => '400px',
        'icon'             => 'el el-file-alt',
		'active_callback' => 'is_front_page'
    ) );
	/*	Slider Module Section Start	*/
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Slider Module', 'beonepage' ),
        'id'               => 'site_front_page_slider_module',
        'desc'             => __( 'These are really basic fields!', 'beonepage' ),
        'customizer_width' => '400px',
        'icon'             => 'el el-adjust-alt',
		'subsection'       => true,
		'fields'           => array(
            array(
                'id'       => 'front_page_text_slider_title',
                'type'     => 'text',
                'title'    => __( 'Heading', 'beonepage' ),
                'desc'     => __( 'If you want to color the word, just wrap it with \"span\" tag.', 'beonepage' ),
                'default'  => $front_page_text_slider_title,
            ),
			array(
                'id'       => 'front_page_text_slider_content',
                'type'     => 'text',
                'title'    => __( 'Content', 'beonepage' ),
                'default'  => $front_page_text_slider_content,
            ),
			array(
                'id'       => 'front_page_text_slider_btn_text',
                'type'     => 'text',
                'title'    => __( 'Button Text', 'beonepage' ),
                'default'  => $front_page_text_slider_btn_text,
					
            ),
			array(
                'id'       => 'front_page_text_slider_btn_url',
                'type'     => 'text',
                'title'    => __( 'Button Url', 'beonepage' ),
                'default'  => $front_page_text_slider_btn_url,
					
            ),
			 array(
                'id'       => 'front_page_text_slider_bg',
                'type'     => 'background',
                'title'    => __( 'Background Image', 'beonepage' ),
                'subtitle' => __('Body background with image, color, etc.', 'beonepage'),
				'default'  => array(
					'background-image'    => $front_page_text_slider_bg['image'],
					'background-position' => $front_page_text_slider_bg['position'],
				),
				'background-color' => false,
				'background-repeat' => false,
				'background-size' => false,
				'background-attachment' => false,
            ), 
			array(
                'id'       => 'front_page_text_slider_parallax',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Parallax Scrolling?', 'beonepage' ),
                'default'  => $front_page_text_slider_parallax,	
            ),
			array(
                'id'       => 'front_page_text_slider_scroll_down',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Scroll Down Button?', 'beonepage' ),
                'default'  => $front_page_text_slider_scroll_down,	
            ),

        )
    ) );
	/* Slider Module Section End */

	/* Icon Service Module Section Start */
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Icon Service Module', 'beonepage' ),
        'id'               => 'site_front_page_icon_service_module',
        'desc'             => '',
        'customizer_width' => '400px',
        'icon'             => 'el el-wrench',
		'subsection'       => true,
		'fields'           => array(
            array(
                'id'       => 'front_page_icon_service_module_id',
                'type'     => 'text',
                'title'    => __( 'Module ID', 'beonepage' ),
                'desc'     => __( 'Set up a unique ID for the module, the ID will be used for page scrolling navigation.', 'beonepage' ),
                'default'  => $front_page_icon_service_module_id,
            ),
			array(
                'id'       => 'front_page_icon_service_module_title',
                'type'     => 'text',
                'title'    => __( 'Title', 'beonepage' ),
                'desc'     =>__( 'If you want to color the word, just wrap it with \"span\" tag.', 'beonepage' ),
                'default'  => $front_page_icon_service_module_title,
            ),
			array(
                'id'       => 'front_page_icon_service_module_subtitle',
                'type'     => 'text',
                'title'    => __( 'Subtitle', 'beonepage' ),
                'default'  => $front_page_icon_service_module_subtitle,
            ),
			array(
                'id'       => 'front_page_icon_service_module_layout',
                'type'     => 'radio',
                'title'    => __( 'Layout', 'beonepage' ),
                'desc'     => __( 'Choose the layout for the container.', 'beonepage' ),
				'default' => $front_page_icon_service_module_layout,
				'options'  => array(
					'fixed' => 'Fixed-width', 
					'full' => 'Full-width'
							),
				)
			)
	) 	);
	/* Icon Service Module Section end */
	
	/* Portfolio Module Section Start */
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Portfolio Module', 'beonepage' ),
        'id'               => 'site_front_page_portfolio_module',
        'desc'             => '',
        'customizer_width' => '400px',
        'icon'             => 'el el-briefcase',
		'subsection'       => true,
		'fields'           => array(
            array(
                'id'       => 'front_page_portfolio_module_id',
                'type'     => 'text',
                'title'    => __( 'Module ID', 'beonepage' ),
                'desc'     => __( 'Set up a unique ID for the module, the ID will be used for page scrolling navigation.', 'beonepage' ),
                'default'  => $front_page_portfolio_module_id,
            ),
			 array(
                'id'       => 'front_page_portfolio_module_title',
                'type'     => 'text',
                'title'    => __( 'Title', 'beonepage' ),
                'default'  => $front_page_portfolio_module_title,
            ),
			array(
                'id'       => 'front_page_portfolio_module_subtitle',
                'type'     => 'textarea',
                'title'    => __( 'Subtitle', 'beonepage' ),
                'default'  => $front_page_portfolio_module_subtitle,
            ),
			 array(
                'id'       => 'front_page_portfolio_module_filter',
                'type'     => 'checkbox',
                'title'    => __( 'Enable Portfolio Filter?', 'beonepage' ),
                'default'  => $front_page_portfolio_module_filter,
            ),
			 array(
                'id'       => 'front_page_portfolio_module_all',
                'type'     => 'text',
                'title'    => __( 'Show All Button Text', 'beonepage' ),
                'default'  => $front_page_portfolio_module_all,
            ),
			
		)
    )	);
   /* Portfolio Module Section End */
   
   /* Vertical Promotion Module Section Start */
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Vertical Promotion Module', 'beonepage' ),
        'id'               => 'site_front_page_ver_promo_module',
        'desc'             => '',
        'customizer_width' => '400px',
        'icon'             => 'el el-resize-vertical',
		'subsection'       => true,
		'fields'           => array(
			array(
				'id'       => 'front_page_ver_promo_module_id',
				'type'     => 'text',
				'title'    => __( 'Module ID', 'beonepage' ),
				'desc'     => __( 'Set up a unique ID for the module, the ID will be used for page scrolling navigation.', 'beonepage' ),
				'default'  => $front_page_ver_promo_module_id,
			),
			array(
				'id'       => 'front_page_ver_promo_title',
				'type'     => 'text',
				'title'    => __( 'Heading', 'beonepage' ),
				'desc'     => __( 'If you want to color the word, just wrap it with \"span\" tag.', 'beonepage' ),
				'default'  => $front_page_ver_promo_title,
			),
			array(
				'id'       => 'front_page_ver_promo_content',
				'type'     => 'text',
				'title'    => __( 'Content', 'beonepage' ),
				'default'  => $front_page_ver_promo_content,
			),
			array(
				'id'       => 'front_page_ver_promo_btn_text',
				'type'     => 'text',
				'title'    => __( 'Button Text', 'beonepage' ),
				'default'  => $front_page_ver_promo_btn_text,
			),
			array(
				'id'       => 'front_page_ver_promo_btn_url',
				'type'     => 'text',
				'title'    => __( 'Button URL', 'beonepage' ),
				'default'  => $front_page_ver_promo_btn_url,
			),
		
			
		)
	)	);
	/* Vertical Promotion Module Section End */
	
	/* Blog Module Section Start */
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Blog Module', 'beonepage' ),
        'id'               => 'site_front_page_blog_module',
        'desc'             => '',
        'customizer_width' => '400px',
        'icon'             => 'el el-blogger',
		'subsection'       => true,
		'fields'           => array(
			array(
				'id'       => 'front_page_blog_module_id',
				'type'     => 'text',
				'title'    => __( 'Module ID', 'beonepage' ),
				'desc'     => __( 'Set up a unique ID for the module, the ID will be used for page scrolling navigation.', 'beonepage' ),
				'default'  => $front_page_blog_module_id,
			),
			array(
				'id'       => 'front_page_blog_module_title',
				'type'     => 'text',
				'title'    => __( 'Title', 'beonepage' ),
				'desc'     => __( 'If you want to color the word, just wrap it with \"span\" tag.', 'beonepage' ),
				'default'  => $front_page_blog_module_title,
			),
			array(
				'id'       => 'front_page_blog_module_subtitle',
				'type'     => 'textarea',
				'title'    => __( 'Subtitle', 'beonepage' ),
				'default'  => $front_page_blog_module_subtitle,
			),
			array(
				'id'       => 'front_page_blog_module_read_more',
				'type'     => 'text',
				'title'    => __( 'Read More Button Text', 'beonepage' ),
				'default'  => $front_page_blog_module_read_more,
			),
			array(
				'id'       => 'front_page_blog_module_view_more',
				'type'     => 'text',
				'title'    => __( 'View More Button Text', 'beonepage' ),
				'default'  => $front_page_blog_module_view_more,
			),
		
			
		)
	)	);
		
	/* Blog Module Section End */
	
	/* Contact Module Section Start */
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Contact Module', 'beonepage' ),
        'id'               => 'site_front_page_contact_module',
        'desc'             => '',
        'customizer_width' => '400px',
        'icon'             => 'el el-briefcase',
		'subsection'       => true,
		'fields'           => array(
            array(
                'id'       => 'front_page_contact_module_id',
                'type'     => 'text',
                'title'    => __( 'Module ID', 'beonepage' ),
                'desc'     => __( 'Set up a unique ID for the module, the ID will be used for page scrolling navigation.', 'beonepage' ),
                'default'  => $front_page_contact_module_id,
            ),
			 array(
                'id'       => 'front_page_contact_module_title',
                'type'     => 'text',
                'title'    => __( 'Title', 'beonepage' ),
                'default'  => $front_page_contact_module_title,
            ),
			array(
                'id'       => 'front_page_contact_module_subtitle',
                'type'     => 'textarea',
                'title'    => __( 'Subtitle', 'beonepage' ),
                'default'  => $front_page_contact_module_subtitle,
            ),
			 array(
                'id'       => 'front_page_contact_module_send',
                'type'     => 'text',
                'title'    => __( 'Send Button Text', 'beonepage' ),
                'default'  => $front_page_contact_module_send,
            ),
		)
    )	);
	/* Contact Module Section End */
	/* Front Page Panel End */
	
	
	/* Site Blog Panel Start */
	Redux::setSection( $opt_name, array(
		'title'      => __( 'Blog Page',  'beonepage' ),
        'icon'      => 'el el-book',
		'id'		=> 'site_blog_page',
		'customizer_width' => '400px',
        'desc' 		=> __( 'Here you can customize your blog pages.', 'beonepage' ),
		'validate_callback' => 'beonepage_is_blog_page_redux',
        'fields'          => array(
			array(
				'id'              => 'blog_page_header_bg',
				'type'            => 'background',
				'title'           => esc_html__( 'Header Image', 'beonepage' ),
				'default'         => $blog_page_header_bg,
				//'output'   => '.page-header',
				'background-repeat' => false,
				'background-size' => false,
				'background-attachment' => false,
			),
		)
    )   );
	/* Site Blog Panel end */	
	/* Site Footer Panel Start */
	
	Redux::setSection( $opt_name, array(
	'title'            => __( 'Site Footer', 'beonepage' ),
	'id'               => 'site_footer',
	'desc'             => '',
	'customizer_width' => '400px',
	'icon'             => 'el el-photo',
	'fields'           => array(
		array(
			'id'       => 'footer_copyright',
			'type'     => 'editor',
			'title'    => __( 'Copyright Information', 'beonepage' ),
			'subtitle' => '',
			'desc'     => __( 'Want to remove the theme byline? See section "Upgrade" for more information.', 'beonepage' ),
			'default'  => $footer_copyright,
			  'args'    => array(
				'wpautop'       => true,
				'media_buttons' => true,
				'textarea_rows' => 5,
				'teeny'         => false,
				'quicktags'     => true,
			)
		),
		array(
			'id'       => 'footer_site_title',
			'type'     => 'checkbox',
			'title'    => esc_html__( 'Show Site Title?', 'beonepage' ),
			'desc'     => '',
			'default'  => $footer_site_title,
		)	
	)
	)	);

	/* Site Footer Panel End */
	/* Upgrade Panel Start */
	Redux::setSection( $opt_name, array(
		'title'       => esc_html__( 'Upgrade',  'beonepage' ),
        'icon'            => 'el el-list-alt',
		'id'			=> 'upgrade_theme',
        'desc'            => '',
        'fields'          => array(
				array(
					'id'              => 'upgrade_theme_info',
					'type'            => 'info',
					'title'           => __( 'Update', 'beonepage' ),
					'default'         => $upgrade_theme_info,
					
				),
			)
		)
	);
	
	/* Upgrade Panel End */	
		
	
    if ( file_exists( dirname( __FILE__ ) . '/../README.md' ) ) {
        $section = array(
            'icon'   => 'el el-list-alt',
            'title'  => __( 'Documentation', 'beonepage' ),
            'fields' => array(
                array(
                    'id'       => '17',
                    'type'     => 'raw',
                    'markdown' => true,
                    'content_path' => dirname( __FILE__ ) . '/../README.md', // FULL PATH, not relative please
                    //'content' => 'Raw content here',
                ),
            ),
        );
        Redux::setSection( $opt_name, $section );
    }
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */

    // If Redux is running as a plugin, this will remove the demo notice and links
    //add_action( 'redux/loaded', 'remove_demo' );

    // Function to test the compiler hook and demo CSS output.
    // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
    //add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

    // Change the arguments after they've been declared, but before the panel is created
    //add_filter('redux/options/' . $opt_name . '/args', 'change_arguments' );

    // Change the default value of a field after it's been set, but before it's been useds
    //add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

    // Dynamically add a section. Can be also used to modify sections/fields
    //add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'beonepage' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'beonepage' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }


