<?php
/**
 * bc-consulting functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package bc-consulting
 */
if ( ! defined( '_bc_consulting_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_bc_consulting_VERSION', '1.0.1' );
}


if ( ! function_exists( 'bc_consulting_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function bc_consulting_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on bc-consulting , use a find and replace
		 * to change 'bc-consulting' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'bc-consulting', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'bc-consulting' ),
			'top-bar' => esc_html__( 'Top Bar', 'bc-consulting' ),
			'footer' => esc_html__( 'End of Footer', 'bc-consulting' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'bc_consulting_custom_background_args', array(
			'default-color' => 'f6f7f9',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
		/*
		* Enable support for Post Formats.
		* See https://developer.wordpress.org/themes/functionality/post-formats/
		*/
		add_theme_support( 'post-formats', array(
			'image',
			'video',
			'gallery',
			'audio',
			'quote'
		) );
		add_theme_support("responsive-embeds");
		add_theme_support( "wp-block-styles" );
		add_theme_support( "align-wide" );
		add_theme_support('editor-styles');

		if ( is_customize_preview() ) {
			require get_template_directory() . '/inc/starter-content.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
			add_theme_support( 'starter-content', bc_consulting_get_starter_content() );
		}
		
	}
endif;
add_action( 'after_setup_theme', 'bc_consulting_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function bc_consulting_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'bc_consulting_content_width', 640 );
}
add_action( 'after_setup_theme', 'bc_consulting_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function bc_consulting_widgets_init() {
	
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'bc-consulting' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'bc-consulting' ),
		'before_widget' => '<section id="%1$s" class="widget aos-animate %2$s" data-aos="fade-up">',
		'after_widget'  => '</section>',
		'before_title'  => '<h4 class="widget-title"><span>',
		'after_title'   => '</span></h4>',
	) );
	
	
	register_sidebar( array(
		'name'          => esc_html__( 'Home Page Slider', 'bc-consulting' ),
		'id'            => 'slider',
		'description'   => esc_html__( 'Add widgets here.', 'bc-consulting' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h4 class="widget-title screen-reader-text"><span>',
		'after_title'   => '</span></h4>',
	) );
	
	register_sidebar( array(
		'name'          => esc_html__( 'Footer', 'bc-consulting' ),
		'id'            => 'footer',
		'description'   => esc_html__( 'Add widgets here.', 'bc-consulting' ),
		'before_widget' => '<div id="%1$s" class="col-12 col-sm-6 col-md-4 widget %2$s aos-animate" data-aos="fade-up">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title"><span>',
		'after_title'   => '</span></h4>',
	) );
	
	register_sidebar(
		array(
			'name'          => esc_html__( 'Logo Right', 'bc-consulting' ),
			'id'            => 'logo-side',
			'description'   => esc_html__( 'Add widgets here.', 'bc-consulting' ),
			'before_widget' => '<section id="%1$s" class="widget  %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		)
	);
	
	
}
add_action( 'widgets_init', 'bc_consulting_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function bc_consulting_scripts() {
	
	wp_enqueue_style( 'Roboto', '//fonts.googleapis.com/css2?family=Roboto:wght@300;400;700' );

	wp_enqueue_style( 'Roboto+Condensed', '//fonts.googleapis.com/css2?family=Roboto+Condensed:wght@100..900' );

	/* PLUGIN CSS */
	wp_enqueue_style( 'bootstrap-5', get_theme_file_uri( '/vendors/bootstrap/css/bootstrap.css' ), array(), '5.0.2' );

	wp_enqueue_style( 'fontawesome-6', get_theme_file_uri( '/vendors/fontawesome/css/all.css' ), array(), '6.5.2' );
	
	wp_enqueue_style( 'scrollbar', get_theme_file_uri( '/vendors/scrollbar/simple-scrollbar.css' ), array(), '1.0.0' );

	wp_enqueue_style( 'owl-carousel', get_theme_file_uri( '/vendors/owl-carousel/assets/owl.carousel.css' ), array(), '1.0.0' );

	wp_enqueue_style( 'aos-next', get_template_directory_uri() . '/vendors/aos-next/aos.css');

	wp_enqueue_style( 'bc-consulting-common', get_theme_file_uri( '/assets/css/bc-consulting-common.css' ), array(), '1.0.0' );

	/* THEME CORE CSS */
	wp_enqueue_style( 'bc-consulting-navigation', get_theme_file_uri( '/assets/css/navigation-menu.css' ), '1.0.0' );
	wp_enqueue_style( 'bc-consulting-style', get_stylesheet_uri(), array('thickbox'), _bc_consulting_VERSION );

	$custom_css = ':root {--primary-color:'.esc_attr( get_theme_mod('__primary_color','#6c757d') ).'; --secondary-color: '.esc_attr( get_theme_mod('__secondary_color','#ddab03') ).'; --nav-wrap-bg:'.esc_attr( get_theme_mod('__secondary_color','#ddab03') ).'; --nav-h-color:'.esc_attr( get_theme_mod('__secondary_color','#ddab03') ).'; --secondary-color-rgb:'.esc_attr( get_theme_mod('__secondary_color','#ddab03') ).'}';
	

	wp_add_inline_style( 'bc-consulting-style', $custom_css );
	
	wp_enqueue_script( 'bootstrap', get_theme_file_uri( '/vendors/bootstrap/js/bootstrap.js' ), 0, '3.3.7', true );
	wp_enqueue_script( 'aos-next-js', get_template_directory_uri() . '/vendors/aos-next/aos.js',0, '3.3.7', true );
		
	wp_enqueue_script( 'bc-consulting', get_theme_file_uri( '/assets/js/bc-consulting.js'), array('jquery','thickbox' ), '1.0.0', true);
	
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'bc_consulting_scripts' );

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses bc_consulting_header_style()
 */
function bc_consulting_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'bc_consulting_custom_header_args', array(
		'default-image' => get_template_directory_uri() . '/assets/images/custom-header.jpg',
		'default-text-color'     => '000000',
		'width'                  => 1000,
		'height'                 => 350,
		'flex-height'            => true,
		'wp-head-callback'       => 'bc_consulting_header_style',
	) ) );
	
	register_default_headers( array(
		'default-image' => array(
		'url' => '%s/assets/image/custom-header.jpg',
		'thumbnail_url' => '%s/assets/images/custom-header.jpg',
		'description' => esc_html__( 'Default Header Image', 'bc-consulting' ),
		),
	));
	
}
add_action( 'after_setup_theme', 'bc_consulting_custom_header_setup' );

if ( ! function_exists( 'bc_consulting_header_style' ) ) :
	/**
	 * Styles the header image and text displayed on the blog.
	 *
	 * @see bc_consulting_custom_header_setup().
	 */
	function bc_consulting_header_style() {
		$header_text_color = get_header_textcolor();
		$header_image	   = get_header_image();
		
		if( !empty( $header_image ) ){
		?>
			<style type="text/css">
				#masthead .container.header-middle{
					background: url( <?php echo esc_url( $header_image );?> ) center center no-repeat;
					background-size: cover;
				}
			</style>
		<?php
		}
		/*
		 * If no custom options for text are set, let's bail.
		 * get_header_textcolor() options: Any hex value, 'blank' to hide text. Default: add_theme_support( 'custom-header' ).
		 */
		if ( get_theme_support( 'custom-header', 'default-text-color' ) === $header_text_color ) {
			return;
		}

		// If we get this far, we have custom styles. Let's do this.
		?>
		<style type="text/css">
		<?php
		// Has the text been hidden?
		if ( ! display_header_text() ) :
			?>
			.site-title,
			.site-description {
				position: absolute;
				clip: rect(1px, 1px, 1px, 1px);
			}
		<?php
		// If the user has set a custom color for the text use that.
		else :
			?>
			a.site-title,
			.site-description {
				color: #<?php echo esc_attr( $header_text_color ); ?>;
			}
		<?php endif; ?>
		</style>
		<?php
	}
endif;

// Include custom style editor (TinyMCE visual editor)
function joyas_shop_add_editor_styles() {
    add_editor_style( 'assets/css/editor-style.css' );
}
add_action( 'admin_init', 'joyas_shop_add_editor_styles' );
add_action( 'wp_head', 'bc_consulting_add_preload_tag', 5);
function bc_consulting_add_preload_tag()
{
	echo '<link rel="preconnect" href="//fonts.googleapis.com" as="style">';
	echo '<link rel="preconnect" href="//fonts.gstatic.com" as="style">';    
}


