<?php
/**
 * SVG Icons definition.
 *
 * @package Bayleaf
 * @since 1.0.0
 */

/**
 * SVG icons definition.
 *
 * @since 1.4.7
 */
function bayleaf_get_font_icons_def() {
	/*
	 * Icons Licensing Information. Following SVG icons has been taken from following sources.
	 * License information is available in readme.txt.
	 * 1. Font Awesome SVG Icons
	 * 2. Icomoon Free SVG Icons
	 * 3. Feather SVG Icons
	 * 4. Genericons Neue Icons
	 * 5. Simple Icons (Beands SVG ICons)
	 * 6. SVG Logos
	 */
	return apply_filters(
		'bayleaf_icon_fonts_def',
		array(
			'arrow-up'         => '<symbol id="icon-arrow-up" viewBox="0 0 32 32"><path d="M30.054 23.768l-2.964 2.946c-0.446 0.446-1.161 0.446-1.607 0l-9.482-9.482-9.482 9.482c-0.446 0.446-1.161 0.446-1.607 0l-2.964-2.946c-0.446-0.446-0.446-1.179 0-1.625l13.25-13.232c0.446-0.446 1.161-0.446 1.607 0l13.25 13.232c0.446 0.446 0.446 1.179 0 1.625z"></path></symbol>',
			'angle-up'         => '<symbol id="icon-angle-up" viewBox="0 0 16 28"><path d="M16 19c0 0.547-0.453 1-1 1h-14c-0.547 0-1-0.453-1-1 0-0.266 0.109-0.516 0.297-0.703l7-7c0.187-0.187 0.438-0.297 0.703-0.297s0.516 0.109 0.703 0.297l7 7c0.187 0.187 0.297 0.438 0.297 0.703z"></path></symbol>',
			'angle-down'       => '<symbol id="icon-angle-down" viewBox="0 0 18 32"><path class="path1" d="M18.286 12.571c0 0.304-0.125 0.589-0.339 0.804l-8 8c-0.214 0.214-0.5 0.339-0.804 0.339s-0.589-0.125-0.804-0.339l-8-8c-0.214-0.214-0.339-0.5-0.339-0.804 0-0.625 0.518-1.143 1.143-1.143h16c0.625 0 1.143 0.518 1.143 1.143z"></path></symbol>',
			'angle-left'       => '<symbol id="icon-angle-left" viewBox="0 0 24 32"><path class="path1" d="M20.911 5.375l-9.482 9.482 9.482 9.482c0.446 0.446 0.446 1.161 0 1.607l-2.964 2.964c-0.446 0.446-1.161 0.446-1.607 0l-13.25-13.25c-0.446-0.446-0.446-1.161 0-1.607l13.25-13.25c0.446-0.446 1.161-0.446 1.607 0l2.964 2.964c0.446 0.446 0.446 1.161 0 1.607z"></path></symbol>',
			'angle-right'      => '<symbol id="icon-angle-right" viewBox="0 0 22 32">
			<path class="path1" d="M19.768 15.661l-13.25 13.25c-0.446 0.446-1.161 0.446-1.607 0l-2.964-2.964c-0.446-0.446-0.446-1.161 0-1.607l9.482-9.482-9.482-9.482c-0.446-0.446-0.446-1.161 0-1.607l2.964-2.964c0.446-0.446 1.161-0.446 1.607 0l13.25 13.25c0.446 0.446 0.446 1.161 0 1.607z"></path>
			</symbol>',
			'mail-reply'       => '<symbol id="icon-mail-reply" viewBox="0 0 32 32"><path class="path1" d="M32 20c0 2.5-1.25 5.768-2.268 8.054-0.196 0.411-0.393 0.982-0.661 1.357-0.125 0.179-0.25 0.304-0.5 0.304-0.357 0-0.571-0.286-0.571-0.625 0-0.286 0.071-0.607 0.089-0.893 0.054-0.732 0.089-1.464 0.089-2.196 0-8.518-5.054-10-12.75-10h-4v4.571c0 0.625-0.518 1.143-1.143 1.143-0.304 0-0.589-0.125-0.804-0.339l-9.143-9.143c-0.214-0.214-0.339-0.5-0.339-0.804s0.125-0.589 0.339-0.804l9.143-9.143c0.214-0.214 0.5-0.339 0.804-0.339 0.625 0 1.143 0.518 1.143 1.143v4.571h4c5.857 0 13.143 1.036 15.625 7.196 0.75 1.893 0.946 3.946 0.946 5.946z"></path></symbol>',
			'headphones'       => '<symbol id="icon-headphones" viewBox="0 0 32 32"><path d="M9 18h-2v14h2c0.55 0 1-0.45 1-1v-12c0-0.55-0.45-1-1-1z"></path><path d="M23 18c-0.55 0-1 0.45-1 1v12c0 0.55 0.45 1 1 1h2v-14h-2z"></path><path d="M32 16c0-8.837-7.163-16-16-16s-16 7.163-16 16c0 1.919 0.338 3.759 0.958 5.464-0.609 1.038-0.958 2.246-0.958 3.536 0 3.526 2.608 6.443 6 6.929v-13.857c-0.997 0.143-1.927 0.495-2.742 1.012-0.168-0.835-0.258-1.699-0.258-2.584 0-7.18 5.82-13 13-13s13 5.82 13 13c0 0.885-0.088 1.749-0.257 2.584-0.816-0.517-1.745-0.87-2.743-1.013v13.858c3.392-0.485 6-3.402 6-6.929 0-1.29-0.349-2.498-0.958-3.536 0.62-1.705 0.958-3.545 0.958-5.465z"></path></symbol>',
			'folder'           => '<symbol id="icon-folder" viewBox="0 0 30 32"><path class="path1" d="M29.714 10.857v12.571c0 2.196-1.804 4-4 4h-21.714c-2.196 0-4-1.804-4-4v-17.143c0-2.196 1.804-4 4-4h5.714c2.196 0 4 1.804 4 4v0.571h12c2.196 0 4 1.804 4 4z"></path></symbol>',
			'tags'             => '<symbol id="icon-tags" viewBox="0 0 34 32"><path class="path1" d="M8 8c0-1.268-1.018-2.286-2.286-2.286s-2.286 1.018-2.286 2.286 1.018 2.286 2.286 2.286 2.286-1.018 2.286-2.286zM27.054 18.286c0 0.607-0.25 1.196-0.661 1.607l-8.768 8.786c-0.429 0.411-1.018 0.661-1.625 0.661s-1.196-0.25-1.607-0.661l-12.768-12.786c-0.911-0.893-1.625-2.625-1.625-3.893v-7.429c0-1.25 1.036-2.286 2.286-2.286h7.429c1.268 0 3 0.714 3.911 1.625l12.768 12.75c0.411 0.429 0.661 1.018 0.661 1.625zM33.911 18.286c0 0.607-0.25 1.196-0.661 1.607l-8.768 8.786c-0.429 0.411-1.018 0.661-1.625 0.661-0.929 0-1.393-0.429-2-1.054l8.393-8.393c0.411-0.411 0.661-1 0.661-1.607s-0.25-1.196-0.661-1.625l-12.768-12.75c-0.911-0.911-2.643-1.625-3.911-1.625h4c1.268 0 3 0.714 3.911 1.625l12.768 12.75c0.411 0.429 0.661 1.018 0.661 1.625z"></path></symbol>',
			'long-arrow-right' => '<symbol id="icon-long-arrow-right" viewBox="0 0 31 32"><path class="path1" d="M30.857 15.946c0 0.161-0.071 0.321-0.179 0.429l-6.857 6.321c-0.179 0.161-0.411 0.196-0.625 0.107-0.196-0.089-0.339-0.286-0.339-0.518v-4h-22.286c-0.321 0-0.571-0.25-0.571-0.571v-3.429c0-0.321 0.25-0.571 0.571-0.571h22.286v-4c0-0.232 0.125-0.429 0.339-0.518s0.446-0.054 0.625 0.089l6.857 6.25c0.107 0.107 0.179 0.25 0.179 0.411v0z"></path></symbol>',
			'trash'            => '<symbol id="icon-trash" viewBox="0 0 25 32"><path class="path1" d="M9.143 13.143v10.286c0 0.321-0.25 0.571-0.571 0.571h-1.143c-0.321 0-0.571-0.25-0.571-0.571v-10.286c0-0.321 0.25-0.571 0.571-0.571h1.143c0.321 0 0.571 0.25 0.571 0.571zM13.714 13.143v10.286c0 0.321-0.25 0.571-0.571 0.571h-1.143c-0.321 0-0.571-0.25-0.571-0.571v-10.286c0-0.321 0.25-0.571 0.571-0.571h1.143c0.321 0 0.571 0.25 0.571 0.571zM18.286 13.143v10.286c0 0.321-0.25 0.571-0.571 0.571h-1.143c-0.321 0-0.571-0.25-0.571-0.571v-10.286c0-0.321 0.25-0.571 0.571-0.571h1.143c0.321 0 0.571 0.25 0.571 0.571zM20.571 26.071v-16.929h-16v16.929c0 0.857 0.482 1.357 0.571 1.357h14.857c0.089 0 0.571-0.5 0.571-1.357zM8.571 6.857h8l-0.857-2.089c-0.054-0.071-0.214-0.179-0.304-0.196h-5.661c-0.107 0.018-0.25 0.125-0.304 0.196zM25.143 7.429v1.143c0 0.321-0.25 0.571-0.571 0.571h-1.714v16.929c0 1.964-1.286 3.643-2.857 3.643h-14.857c-1.571 0-2.857-1.607-2.857-3.571v-17h-1.714c-0.321 0-0.571-0.25-0.571-0.571v-1.143c0-0.321 0.25-0.571 0.571-0.571h5.518l1.25-2.982c0.357-0.875 1.429-1.589 2.375-1.589h5.714c0.946 0 2.018 0.714 2.375 1.589l1.25 2.982h5.518c0.321 0 0.571 0.25 0.571 0.571z"></path></symbol>',
			'email'            => '<symbol id="icon-email" viewBox="0 0 32 32"><path class="path1" d="M29.714 26.857v-13.714c-0.375 0.429-0.786 0.821-1.232 1.179-2.554 1.964-5.125 3.964-7.607 6.036-1.339 1.125-3 2.5-4.857 2.5h-0.036c-1.857 0-3.518-1.375-4.857-2.5-2.482-2.071-5.054-4.071-7.607-6.036-0.446-0.357-0.857-0.75-1.232-1.179v13.714c0 0.304 0.268 0.571 0.571 0.571h26.286c0.304 0 0.571-0.268 0.571-0.571zM29.714 8.089c0-0.446 0.107-1.232-0.571-1.232h-26.286c-0.304 0-0.571 0.268-0.571 0.571 0 2.036 1.018 3.804 2.625 5.071 2.393 1.875 4.786 3.768 7.161 5.661 0.946 0.768 2.661 2.411 3.911 2.411h0.036c1.25 0 2.964-1.643 3.911-2.411 2.375-1.893 4.768-3.786 7.161-5.661 1.161-0.911 2.625-2.893 2.625-4.411zM32 7.429v19.429c0 1.571-1.286 2.857-2.857 2.857h-26.286c-1.571 0-2.857-1.286-2.857-2.857v-19.429c0-1.571 1.286-2.857 2.857-2.857h26.286c1.571 0 2.857 1.286 2.857 2.857z"></path></symbol>',
			'comment'          => '<symbol id="icon-comment" viewBox="0 0 32 32"><path class="path1" d="M32 16c0 6.321-7.161 11.429-16 11.429-0.875 0-1.75-0.054-2.589-0.143-2.339 2.071-5.125 3.536-8.214 4.321-0.643 0.179-1.339 0.304-2.036 0.393-0.393 0.036-0.768-0.25-0.857-0.679v-0.018c-0.089-0.446 0.214-0.714 0.482-1.036 1.125-1.268 2.411-2.339 3.25-5.321-3.679-2.089-6.036-5.321-6.036-8.946 0-6.304 7.161-11.429 16-11.429s16 5.107 16 11.429z"></path></symbol>',
			'play'             => '<symbol id="icon-play" viewBox="0 0 25 32"><path d="M24.714 16.554l-23.714 13.179c-0.554 0.304-1 0.036-1-0.589v-26.286c0-0.625 0.446-0.893 1-0.589l23.714 13.179c0.554 0.304 0.554 0.804 0 1.107z"></path></symbol>',
			'close'            => '<symbol id="icon-close" viewBox="0 0 32 32"><path class="path1" d="M17.867 16l7.067-7.067c0.533-0.533 0.533-1.333 0-1.867s-1.333-0.533-1.867 0l-7.067 7.067-7.067-7.067c-0.533-0.533-1.333-0.533-1.867 0s-0.533 1.333 0 1.867l7.067 7.067-7.067 7.067c-0.533 0.533-0.533 1.333 0 1.867 0.267 0.267 0.533 0.4 0.933 0.4s0.667-0.133 0.933-0.4l7.067-7.067 7.067 7.067c0.267 0.267 0.667 0.4 0.933 0.4s0.667-0.133 0.933-0.4c0.533-0.533 0.533-1.333 0-1.867l-7.067-7.067z"></path></symbol>',
			'search'           => '<symbol id="icon-search" viewBox="0 0 32 32"><path d="M21.388 21.141c-0.045 0.035-0.089 0.073-0.132 0.116s-0.080 0.085-0.116 0.132c-1.677 1.617-3.959 2.611-6.473 2.611-2.577 0-4.909-1.043-6.6-2.733s-2.733-4.023-2.733-6.6 1.043-4.909 2.733-6.6 4.023-2.733 6.6-2.733 4.909 1.043 6.6 2.733 2.733 4.023 2.733 6.6c0 2.515-0.993 4.796-2.612 6.475zM28.943 27.057l-4.9-4.9c1.641-2.053 2.624-4.657 2.624-7.491 0-3.313-1.344-6.315-3.515-8.485s-5.172-3.515-8.485-3.515-6.315 1.344-8.485 3.515-3.515 5.172-3.515 8.485 1.344 6.315 3.515 8.485 5.172 3.515 8.485 3.515c2.833 0 5.437-0.983 7.491-2.624l4.9 4.9c0.521 0.521 1.365 0.521 1.885 0s0.521-1.365 0-1.885z"></path></symbol>',
			'sticky'           => '<symbol id="icon-sticky" viewBox="0 0 32 32"><path d="M24 16c0-1-1-2-2-2h-1.2l-0.6-6c1-0.2 1.8-1 1.8-2s-1-2-2-2h-8c-1 0-2 1-2 2s0.8 1.8 1.8 2l-0.6 6h-1.2c-1 0-2 1-2 2v2h6v12l4-2v-10h6v-2z"></path></symbol>',
			'cart'             => '<symbol id="icon-cart" viewBox="0 0 32 32"><path d="M22 24c-1.2 0-2 0.8-2 2s0.8 2 2 2 2-0.8 2-2-0.8-2-2-2zM10 24c-1.2 0-2 0.8-2 2s0.8 2 2 2 2-0.8 2-2-0.8-2-2-2zM22 20h-12v-2h11.2c1.6 0 3-1 3.8-2.6l3-7.4h-18v-2c0-1.2-0.8-2-2-2h-4v2h4v14c0 1.2 0.8 2 2 2h14c0-1.2-0.8-2-2-2z"></path></symbol>',
			'flickity-button'  => '<symbol id="icon-flickity-button" viewBox="0 0 100 100"><path d="M 10,50 L 60,100 L 70,90 L 30,50  L 70,10 L 60,0 Z" class="arrow"></path></symbol>',
			'behance'          => '<symbol id="icon-behance" viewBox="0 0 32 32"><path fill="#1769ff" style="fill: var(--color1, #1769ff)" d="M9.251 6.004c0.936 0 1.787 0.080 2.56 0.251 0.769 0.173 1.427 0.44 1.98 0.813 0.547 0.373 0.977 0.867 1.28 1.493 0.3 0.627 0.453 1.4 0.453 2.307 0 0.987-0.227 1.813-0.676 2.48-0.451 0.667-1.116 1.2-2.003 1.627 1.208 0.347 2.101 0.96 2.696 1.827 0.597 0.88 0.887 1.933 0.887 3.147 0 1-0.173 1.853-0.547 2.573-0.373 0.733-0.893 1.333-1.547 1.8-0.64 0.464-1.4 0.8-2.227 1.023-0.813 0.22-1.669 0.339-2.547 0.339h-9.561v-19.669h9.251zM22.587 22.22c0.587 0.571 1.431 0.857 2.525 0.857 0.787 0 1.467-0.197 2.040-0.596 0.565-0.387 0.907-0.813 1.040-1.253h3.451c-0.537 1.707-1.397 2.933-2.533 3.667-1.133 0.747-2.512 1.107-4.107 1.107-1.116 0-2.112-0.173-3.029-0.533-0.897-0.36-1.653-0.867-2.293-1.52-0.619-0.653-1.097-1.44-1.436-2.36-0.337-0.92-0.497-1.933-0.497-3.027 0-1.071 0.18-2.053 0.537-2.973 0.36-0.933 0.859-1.707 1.493-2.387 0.66-0.68 1.417-1.193 2.315-1.592s1.867-0.577 2.96-0.577c1.213 0 2.253 0.219 3.173 0.697 0.893 0.453 1.627 1.093 2.213 1.867 0.587 0.781 1 1.68 1.253 2.693 0.253 1 0.333 2.053 0.28 3.173h-10.253c0 1.12 0.373 2.176 0.947 2.753l-0.107 0.040zM8.933 22.287c0.423 0 0.827-0.040 1.208-0.124 0.387-0.080 0.731-0.22 1.017-0.4 0.28-0.18 0.52-0.437 0.693-0.777 0.173-0.32 0.253-0.76 0.253-1.28 0-1-0.293-1.72-0.853-2.16-0.573-0.427-1.32-0.64-2.253-0.64h-4.679v5.4h4.613zM27.076 14.753c-0.469-0.513-1.253-0.789-2.209-0.789-0.624 0-1.14 0.099-1.555 0.317-0.403 0.2-0.733 0.467-0.987 0.787s-0.423 0.64-0.523 1c-0.1 0.347-0.16 0.667-0.18 0.947h6.349c-0.093-1-0.44-1.733-0.907-2.253zM8.693 13.933c0.765 0 1.4-0.179 1.9-0.549 0.499-0.36 0.739-0.96 0.739-1.784 0-0.459-0.093-0.833-0.24-1.128-0.173-0.293-0.4-0.52-0.667-0.683-0.28-0.165-0.6-0.28-0.96-0.343-0.36-0.071-0.747-0.099-1.12-0.099h-4.039v4.587zM20.824 7.323h7.957v1.939h-7.957v-1.955z"></path></symbol>',
			'codepen'          => '<symbol id="icon-codepen" viewBox="0 0 32 32"><path d="M32 10.909l-0.024-0.116-0.023-0.067c-0.013-0.032-0.024-0.067-0.040-0.1-0.004-0.024-0.020-0.045-0.027-0.067l-0.047-0.089-0.040-0.067-0.059-0.080-0.061-0.060-0.080-0.060-0.061-0.040-0.080-0.059-0.059-0.053-0.020-0.027-14.607-9.772c-0.463-0.309-1.061-0.309-1.523 0l-14.805 9.883-0.051 0.053-0.067 0.075-0.049 0.060-0.067 0.080c-0.027 0.023-0.040 0.040-0.040 0.061l-0.067 0.080-0.027 0.080c-0.027 0.013-0.027 0.053-0.040 0.093l-0.013 0.067c-0.025 0.041-0.025 0.081-0.025 0.121v9.996c0 0.059 0.004 0.12 0.013 0.18l0.013 0.061c0.007 0.040 0.013 0.080 0.027 0.115l0.020 0.067c0.013 0.036 0.021 0.071 0.036 0.1l0.029 0.067c0 0.013 0.020 0.053 0.040 0.080l0.040 0.053c0.020 0.013 0.040 0.053 0.060 0.080l0.040 0.053 0.053 0.053c0.013 0.017 0.013 0.040 0.040 0.040l0.080 0.056 0.053 0.040 0.013 0.019 14.627 9.773c0.219 0.16 0.5 0.217 0.76 0.217s0.52-0.080 0.76-0.24l14.877-9.875 0.069-0.077 0.044-0.060 0.053-0.080 0.040-0.067 0.040-0.093 0.021-0.069 0.040-0.103 0.020-0.060 0.040-0.107v-10c0-0.067 0-0.127-0.021-0.187l-0.019-0.060 0.059 0.004zM16.013 19.283l-4.867-3.253 4.867-3.256 4.867 3.253zM14.635 10.384l-5.964 3.987-4.817-3.221 10.781-7.187zM6.195 16.028l-3.443 2.307v-4.601zM8.671 17.695l5.964 3.987v6.427l-10.781-7.188 4.824-3.223zM17.387 21.681l5.965-3.973 4.817 3.227-10.783 7.187zM25.827 16.041l3.444-2.293v4.608zM23.353 14.388l-5.964-3.988v-6.44l10.78 7.187-4.816 3.22z"></path></symbol>',
			'deviantart'       => '<symbol id="icon-deviantart" viewBox="0 0 32 32"><path fill="#05cc47" style="fill: var(--color2, #05cc47)" d="M25.609 6.392l0.307-0.573v-5.819h-5.823l-0.581 0.587-2.744 5.233-0.861 0.581h-9.8v7.991h5.387l0.48 0.581-5.567 10.64-0.32 0.573v5.813h5.82l0.581-0.587 2.76-5.233 0.859-0.581h9.8v-7.991h-5.4l-0.48-0.584z"></path></symbol>',
			'digg'             => '<symbol id="icon-digg" viewBox="0 0 32 32"><path d="M23.68 10.88v10.88h5.12v1.28h-5.12v2.56h8.32v-14.72zM14.080 10.88v10.88h5.12v1.28h-5.12v2.56h8.32v-14.72zM5.12 6.4v4.48h-5.12v10.88h8.32v-15.36zM12.8 10.88h-3.2v10.88h3.2zM28.8 19.2h-1.92v-5.76h1.92zM5.12 19.2h-1.92v-5.76h1.92zM19.2 19.2h-1.92v-5.76h1.92zM12.8 6.4h-3.2v3.2h3.2z"></path></symbol>',
			'docker'           => '<symbol id="icon-docker" viewBox="0 0 32 32"><path fill="#1488c6" style="fill: var(--color3, #1488c6)" d="M6.427 23.033c-0.912 0-1.739-0.747-1.739-1.653s0.747-1.657 1.74-1.657c0.997 0 1.747 0.747 1.747 1.656s-0.829 1.653-1.748 1.655zM27.776 14.016c-0.18-1.323-1-2.4-2.080-3.227l-0.42-0.333-0.339 0.413c-0.659 0.747-0.92 2.071-0.84 3.060 0.080 0.749 0.32 1.493 0.739 2.072-0.339 0.173-0.757 0.333-1.080 0.503-0.76 0.249-1.499 0.333-2.24 0.333h-21.387l-0.080 0.493c-0.16 1.576 0.080 3.227 0.749 4.72l0.325 0.58v0.080c2 3.311 5.56 4.8 9.437 4.8 7.459 0 13.576-3.227 16.476-10.177 1.9 0.083 3.819-0.413 4.72-2.235l0.24-0.413-0.4-0.249c-1.080-0.659-2.56-0.747-3.8-0.413zM17.099 12.693h-3.237v3.227h3.24v-3.229zM17.099 8.636h-3.237v3.227h3.24v-3.223zM17.099 4.497h-3.237v3.227h3.24v-3.227zM21.059 12.693h-3.219v3.227h3.227v-3.229zM9.061 12.693h-3.217v3.227h3.229v-3.229zM13.101 12.693h-3.2v3.227h3.219v-3.229zM5.061 12.693h-3.195v3.227h3.237v-3.229zM13.101 8.636h-3.2v3.227h3.219v-3.223zM9.041 8.636h-3.192v3.227h3.217v-3.223z"></path></symbol>',
			'dribbble'         => '<symbol id="icon-dribbble" viewBox="0 0 32 32"><path fill="#e74d89" style="fill: var(--color1, #e74d89)" d="M16 1.063c8.25 0 14.925 6.675 14.925 14.912s-6.675 14.925-14.925 14.925-14.925-6.675-14.925-14.912 6.675-14.925 14.925-14.925z"></path><path fill="#b2215a" style="fill: var(--color2, #b2215a)" d="M16 31.962c-8.825 0-16-7.163-16-15.975 0-8.825 7.175-15.988 16-15.988s16 7.162 16 15.975-7.175 15.988-16 15.988zM29.488 18.163c-0.462-0.15-4.225-1.262-8.512-0.587 1.788 4.9 2.512 8.9 2.65 9.725 3.075-2.063 5.262-5.337 5.863-9.137zM21.337 28.563c-0.2-1.2-1-5.375-2.913-10.35-0.025 0.012-0.063 0.025-0.087 0.025-7.713 2.688-10.475 8.025-10.725 8.525 2.313 1.8 5.225 2.875 8.387 2.875 1.888 0.012 3.7-0.375 5.338-1.075zM5.85 25.125c0.313-0.525 4.063-6.725 11.112-9.012 0.175-0.063 0.363-0.113 0.538-0.162-0.337-0.775-0.712-1.55-1.113-2.313-6.825 2.037-13.45 1.95-14.050 1.938 0 0.137-0.013 0.275-0.013 0.412 0.013 3.512 1.337 6.713 3.525 9.137zM2.625 13.2c0.612 0.012 6.238 0.037 12.637-1.662-2.262-4.025-4.713-7.4-5.063-7.888-3.838 1.8-6.688 5.325-7.575 9.55zM12.8 2.725c0.375 0.5 2.863 3.875 5.1 7.988 4.863-1.825 6.913-4.575 7.163-4.925-2.413-2.138-5.587-3.438-9.063-3.438-1.1 0-2.175 0.138-3.2 0.375zM26.575 7.362c-0.288 0.388-2.575 3.325-7.625 5.388 0.313 0.65 0.625 1.313 0.913 1.975 0.1 0.238 0.2 0.475 0.3 0.7 4.55-0.575 9.063 0.35 9.512 0.438-0.038-3.213-1.188-6.175-3.1-8.5z"></path></symbol>',
			'facebook'         => '<symbol id="icon-facebook" viewBox="0 0 32 32"><path fill="#395185" style="fill: var(--color1, #395185)" d="M30.234 32c0.975 0 1.766-0.791 1.766-1.766v-28.468c0-0.976-0.791-1.766-1.766-1.766h-28.468c-0.976 0-1.766 0.791-1.766 1.766v28.468c0 0.975 0.79 1.766 1.766 1.766h28.468z"></path><path fill="#fff" style="fill: var(--color2, #fff)" d="M22.079 32v-12.392h4.16l0.623-4.829h-4.782v-3.084c0-1.398 0.388-2.351 2.393-2.351l2.557-0.001v-4.319c-0.442-0.059-1.96-0.19-3.727-0.19-3.687 0-6.212 2.251-6.212 6.384v3.562h-4.17v4.829h4.17v12.392h4.987z"></path></symbol>',
			'flickr'           => '<symbol id="icon-flickr" viewBox="0 0 32 32"><path fill="#ec407a" style="fill: var(--color1, #ec407a)" d="M32 16c0 3.935-3.19 7.125-7.125 7.125s-7.125-3.19-7.125-7.125c0-3.935 3.19-7.125 7.125-7.125s7.125 3.19 7.125 7.125z"></path><path fill="#1976d2" style="fill: var(--color2, #1976d2)" d="M14.25 16c0 3.935-3.19 7.125-7.125 7.125s-7.125-3.19-7.125-7.125c0-3.935 3.19-7.125 7.125-7.125s7.125 3.19 7.125 7.125z"></path></symbol>',
			'github'           => '<symbol id="icon-github" viewBox="0 0 32 32"><path d="M16 0.396c-8.84 0-16 7.164-16 16 0 7.071 4.584 13.067 10.94 15.18 0.8 0.151 1.093-0.344 1.093-0.769 0-0.38-0.013-1.387-0.020-2.72-4.451 0.965-5.389-2.147-5.389-2.147-0.728-1.847-1.78-2.34-1.78-2.34-1.449-0.992 0.112-0.972 0.112-0.972 1.607 0.112 2.451 1.648 2.451 1.648 1.427 2.447 3.745 1.74 4.66 1.331 0.144-1.035 0.556-1.74 1.013-2.14-3.553-0.4-7.288-1.776-7.288-7.907 0-1.747 0.62-3.173 1.647-4.293-0.18-0.404-0.72-2.031 0.14-4.235 0 0 1.34-0.429 4.4 1.64 1.28-0.356 2.64-0.532 4-0.54 1.36 0.008 2.72 0.184 4 0.54 3.040-2.069 4.38-1.64 4.38-1.64 0.86 2.204 0.32 3.831 0.16 4.235 1.020 1.12 1.64 2.547 1.64 4.293 0 6.147-3.74 7.5-7.3 7.893 0.56 0.48 1.080 1.461 1.080 2.96 0 2.141-0.020 3.861-0.020 4.381 0 0.42 0.28 0.92 1.1 0.76 6.401-2.099 10.981-8.099 10.981-15.159 0-8.836-7.164-16-16-16z"></path></symbol>',
			'instagram'        => '<symbol id="icon-instagram" viewBox="0 0 32 32"><path d="M16 2.883c4.272 0 4.778 0.016 6.465 0.093 1.56 0.071 2.407 0.332 2.971 0.551 0.747 0.29 1.28 0.637 1.84 1.197s0.907 1.093 1.197 1.84c0.219 0.564 0.48 1.411 0.551 2.971 0.077 1.687 0.093 2.193 0.093 6.465s-0.016 4.778-0.093 6.465c-0.071 1.56-0.332 2.407-0.551 2.971-0.29 0.747-0.637 1.28-1.197 1.84s-1.093 0.907-1.84 1.197c-0.564 0.219-1.411 0.48-2.971 0.551-1.687 0.077-2.193 0.093-6.465 0.093s-4.779-0.016-6.465-0.093c-1.56-0.071-2.407-0.332-2.971-0.551-0.747-0.29-1.28-0.637-1.84-1.197s-0.907-1.093-1.197-1.84c-0.219-0.564-0.48-1.411-0.551-2.971-0.077-1.687-0.093-2.193-0.093-6.465s0.016-4.778 0.093-6.465c0.071-1.56 0.332-2.407 0.551-2.971 0.29-0.747 0.637-1.28 1.197-1.84s1.093-0.907 1.84-1.197c0.564-0.219 1.411-0.48 2.971-0.551 1.687-0.077 2.193-0.093 6.465-0.093zM16 0c-4.345 0-4.89 0.018-6.597 0.096-1.703 0.078-2.866 0.348-3.884 0.744-1.052 0.409-1.944 0.956-2.834 1.846s-1.437 1.782-1.845 2.834c-0.396 1.018-0.666 2.181-0.744 3.884-0.078 1.707-0.096 2.251-0.096 6.597s0.018 4.89 0.096 6.597c0.078 1.703 0.348 2.866 0.744 3.884 0.409 1.052 0.956 1.945 1.845 2.834s1.782 1.436 2.834 1.845c1.018 0.396 2.181 0.666 3.884 0.744 1.707 0.078 2.252 0.096 6.597 0.096s4.89-0.018 6.597-0.096c1.703-0.078 2.866-0.348 3.884-0.744 1.052-0.409 1.945-0.956 2.834-1.845s1.437-1.782 1.846-2.834c0.395-1.018 0.666-2.181 0.744-3.884 0.078-1.707 0.096-2.252 0.096-6.597s-0.018-4.89-0.096-6.597c-0.078-1.703-0.348-2.866-0.744-3.884-0.409-1.052-0.956-1.944-1.846-2.834s-1.782-1.437-2.834-1.845c-1.018-0.396-2.181-0.666-3.884-0.744-1.706-0.078-2.251-0.096-6.597-0.096zM16 7.784c-4.538 0-8.216 3.679-8.216 8.216s3.678 8.216 8.216 8.216c4.538 0 8.216-3.678 8.216-8.216s-3.679-8.216-8.216-8.216zM16 21.333c-2.945 0-5.333-2.388-5.333-5.333s2.388-5.333 5.333-5.333 5.333 2.388 5.333 5.333-2.388 5.333-5.333 5.333zM26.461 7.459c0 1.060-0.86 1.92-1.92 1.92s-1.92-0.86-1.92-1.92c0-1.060 0.86-1.92 1.92-1.92s1.92 0.86 1.92 1.92z"></path></symbol>',
			'linkedin'         => '<symbol id="icon-linkedin" viewBox="0 0 32 32"><path fill="#0077b5" style="fill: var(--color8, #0077b5)" d="M27.263 27.269h-4.739v-7.425c0-1.771-0.036-4.049-2.469-4.049-2.471 0-2.848 1.927-2.848 3.919v7.556h-4.739v-15.269h4.552v2.081h0.061c0.636-1.2 2.183-2.467 4.493-2.467 4.801 0 5.689 3.16 5.689 7.273zM7.116 9.911c-1.525 0-2.751-1.235-2.751-2.753 0-1.517 1.227-2.751 2.751-2.751 1.52 0 2.752 1.233 2.752 2.751 0 1.519-1.233 2.753-2.752 2.753zM9.492 27.269h-4.752v-15.269h4.752zM29.633 0h-27.272c-1.305 0-2.361 1.032-2.361 2.305v27.389c0 1.275 1.056 2.305 2.361 2.305h27.268c1.304 0 2.371-1.031 2.371-2.305v-27.389c0-1.273-1.067-2.305-2.371-2.305z"></path></symbol>',
			'medium'           => '<symbol id="icon-medium" viewBox="0 0 32 32"><path d="M0 0v32h32v-32zM26.584 7.581l-1.716 1.645c-0.121 0.092-0.198 0.237-0.198 0.399 0 0.030 0.003 0.059 0.007 0.087l-0-0.003v12.089c-0.004 0.025-0.007 0.053-0.007 0.083 0 0.162 0.077 0.306 0.196 0.398l0.001 0.001 1.676 1.645v0.361h-8.429v-0.36l1.736-1.687c0.171-0.171 0.171-0.22 0.171-0.48v-9.773l-4.827 12.26h-0.653l-5.621-12.26v8.217c-0.007 0.046-0.010 0.099-0.010 0.152 0 0.307 0.122 0.586 0.321 0.791l-0-0 2.259 2.739v0.361h-6.403v-0.36l2.26-2.74c0.189-0.196 0.306-0.464 0.306-0.759 0-0.065-0.006-0.129-0.017-0.19l0.001 0.007v-9.501c0.003-0.025 0.004-0.055 0.004-0.085 0-0.245-0.106-0.465-0.274-0.617l-0.001-0.001-2.008-2.419v-0.36h6.232l4.817 10.564 4.235-10.565h5.941z"></path></symbol>',
			'pinterest'        => '<symbol id="icon-pinterest" viewBox="0 0 32 32"><path fill="#bd081c" style="fill: var(--color16, #bd081c)" d="M16.023 0c-8.828 0-15.984 7.156-15.984 15.983 0 6.772 4.211 12.556 10.157 14.883-0.14-1.265-0.265-3.204 0.055-4.585 0.292-1.249 1.875-7.943 1.875-7.943s-0.479-0.96-0.479-2.375c0-2.217 1.289-3.881 2.891-3.881 1.365 0 2.024 1.025 2.024 2.251 0 1.372-0.871 3.423-1.323 5.323-0.38 1.591 0.8 2.887 2.367 2.887 2.837 0 5.024-2.993 5.024-7.316 0-3.815-2.751-6.492-6.677-6.492-4.547 0-7.212 3.416-7.212 6.932 0 1.377 0.525 2.857 1.185 3.655 0.132 0.16 0.149 0.3 0.113 0.46-0.12 0.5-0.391 1.599-0.445 1.817-0.071 0.3-0.229 0.361-0.535 0.22-1.993-0.92-3.244-3.837-3.244-6.195 0-5.035 3.664-9.669 10.56-9.669 5.544 0 9.856 3.956 9.856 9.231 0 5.513-3.476 9.949-8.311 9.949-1.619 0-3.139-0.839-3.677-1.839l-0.999 3.797c-0.359 1.393-1.339 3.136-1.997 4.195 1.497 0.46 3.075 0.713 4.733 0.713 8.809 0 15.98-7.153 15.98-15.983 0-8.831-7.171-15.983-15.98-15.983z"></path></symbol>',
			'reddit'           => '<symbol id="icon-reddit" viewBox="0 0 32 32"><path fill="#ff4500" style="fill: var(--color3, #ff4500)" d="M32 16c0 8.837-7.163 16-16 16s-16-7.163-16-16c0-8.837 7.163-16 16-16s16 7.163 16 16z"></path><path fill="#fff" style="fill: var(--color4, #fff)" d="M26.644 16.152c0-1.297-1.049-2.327-2.327-2.327-0.001 0-0.002 0-0.003 0-0.628 0-1.198 0.247-1.619 0.649l0.001-0.001c-1.602-1.145-3.796-1.888-6.238-1.984l1.068-4.998 3.472 0.744c0.038 0.877 0.763 1.583 1.66 1.583 0.916 0 1.659-0.744 1.659-1.66s-0.744-1.659-1.659-1.659c-0.648 0-1.221 0.381-1.488 0.935l-3.872-0.82c-0.114-0.019-0.229 0-0.305 0.057-0.095 0.057-0.152 0.152-0.171 0.267l-1.183 5.57c-2.48 0.076-4.712 0.82-6.333 1.984-0.42-0.401-0.99-0.649-1.618-0.649-0.001 0-0.002 0-0.004 0h0c-1.297 0-2.327 1.049-2.327 2.327 0 0.954 0.572 1.755 1.373 2.117-0.036 0.208-0.057 0.447-0.057 0.691 0 0.005 0 0.010 0 0.015v-0.001c0 3.586 4.178 6.505 9.328 6.505s9.328-2.899 9.328-6.505c-0-0.249-0.021-0.494-0.061-0.732l0.004 0.026c0.801-0.363 1.373-1.183 1.373-2.137zM10.659 17.812c0-0.916 0.744-1.659 1.66-1.659s1.659 0.744 1.659 1.659-0.744 1.66-1.659 1.66c-0.916 0.019-1.66-0.744-1.66-1.66zM19.949 22.218c-1.145 1.145-3.319 1.221-3.948 1.221-0.649 0-2.823-0.096-3.949-1.221-0.171-0.172-0.171-0.439 0-0.61s0.439-0.171 0.611 0c0.725 0.725 2.251 0.973 3.338 0.973s2.632-0.248 3.338-0.973c0.172-0.171 0.439-0.171 0.61 0 0.152 0.172 0.152 0.439 0 0.61zM19.643 19.491c-0.916 0-1.659-0.744-1.659-1.659s0.744-1.659 1.659-1.659c0.916 0 1.66 0.744 1.66 1.659 0 0.896-0.744 1.659-1.66 1.659z"></path></symbol>',
			'snapchat'         => '<symbol id="icon-snapchat" viewBox="0 0 32 32"><path fill="#fffc00" style="fill: var(--color11, #fffc00)" d="M16.275 1.057c1.32 0 5.796 0.368 7.907 5.095 0.705 1.591 0.537 4.292 0.399 6.463l-0.004 0.080c-0.016 0.24-0.029 0.46-0.040 0.68 0.1 0.060 0.271 0.12 0.535 0.12 0.4-0.021 0.879-0.16 1.377-0.401 0.22-0.117 0.459-0.139 0.619-0.139 0.243 0 0.479 0.039 0.679 0.12 0.6 0.199 0.979 0.639 0.979 1.117 0.020 0.599-0.52 1.119-1.617 1.557-0.119 0.039-0.279 0.1-0.459 0.159-0.6 0.18-1.519 0.48-1.777 1.080-0.12 0.299-0.081 0.699 0.16 1.157l0.020 0.020c0.080 0.181 2.035 4.633 6.388 5.352 0.34 0.059 0.58 0.36 0.56 0.679 0 0.1-0.020 0.199-0.060 0.3-0.32 0.759-1.697 1.317-4.195 1.695-0.079 0.121-0.16 0.5-0.219 0.76-0.039 0.239-0.099 0.48-0.179 0.737-0.101 0.361-0.36 0.54-0.74 0.54h-0.040c-0.18 0-0.417-0.041-0.717-0.099-0.48-0.1-1.020-0.18-1.697-0.18-0.4 0-0.799 0.020-1.217 0.099-0.8 0.139-1.497 0.619-2.297 1.179-1.137 0.799-2.435 1.717-4.392 1.717-0.080 0-0.159-0.020-0.24-0.020h-0.199c-1.957 0-3.236-0.9-4.372-1.717-0.799-0.56-1.476-1.039-2.276-1.179-0.419-0.060-0.839-0.099-1.237-0.099-0.72 0-1.277 0.119-1.696 0.199-0.281 0.057-0.521 0.099-0.72 0.099-0.499 0-0.697-0.299-0.777-0.56-0.081-0.256-0.12-0.519-0.18-0.756-0.061-0.241-0.14-0.659-0.221-0.76-2.557-0.296-3.933-0.856-4.252-1.635-0.041-0.084-0.069-0.2-0.073-0.3-0.020-0.324 0.22-0.62 0.56-0.679 4.352-0.72 6.307-5.172 6.388-5.36l0.021-0.039c0.24-0.46 0.299-0.86 0.159-1.159-0.26-0.579-1.179-0.877-1.776-1.079-0.161-0.039-0.32-0.099-0.461-0.159-1.476-0.58-1.676-1.24-1.596-1.697 0.12-0.639 0.899-1.057 1.557-1.057 0.195 0 0.36 0.039 0.511 0.099 0.56 0.259 1.052 0.4 1.472 0.4 0.312 0 0.512-0.080 0.62-0.14l-0.061-0.759c-0.131-2.168-0.3-4.868 0.409-6.449 2.052-4.703 6.515-5.063 7.832-5.063l0.559-0.020z"></path></symbol>',
			'soundcloud'       => '<symbol id="icon-soundcloud" viewBox="0 0 57 32"><path fill="#000" style="fill: var(--color1, #000)" d="M24.269 17.982l-0.33-12.025c0-0.374-0.308-0.66-0.659-0.66-0.374 0-0.659 0.286-0.659 0.66l-0.308 12.025 0.308 5.781c0 0.374 0.308 0.66 0.659 0.66 0.374 0 0.659-0.286 0.659-0.66l0.33-5.781z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M21.895 17.982l-0.374-12.487c0-0 0-0.001 0-0.001 0-0.339-0.275-0.614-0.614-0.614-0 0-0.001 0-0.001 0h0c-0 0-0.001 0-0.001 0-0.339 0-0.614 0.275-0.614 0.614 0 0 0 0.001 0 0.001v-0l-0.329 12.465 0.33 5.825c0 0 0 0.001 0 0.001 0 0.339 0.275 0.614 0.614 0.614 0 0 0.001 0 0.001 0h-0c0 0 0.001 0 0.001 0 0.339 0 0.614-0.275 0.614-0.614 0-0 0-0.001 0-0.001v0l0.373-5.803z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M16.773 5.584c-0.022-0.286-0.242-0.527-0.527-0.527s-0.506 0.22-0.528 0.527l-0.374 12.376 0.374 5.913c0 0.286 0.242 0.506 0.527 0.506s0.506-0.22 0.528-0.527l0.44-5.914-0.44-12.354z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M19.147 5.166c0-0.308-0.264-0.572-0.572-0.572-0.001 0-0.003 0-0.004 0-0.314 0-0.568 0.254-0.568 0.568 0 0.001 0 0.003 0 0.004v-0l-0.352 12.794 0.352 5.869c0 0.308 0.264 0.572 0.572 0.572s0.55-0.242 0.572-0.572l0.396-5.869-0.396-12.794z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M7.166 24.247c0.176 0 0.308-0.132 0.33-0.329l0.572-5.958-0.572-6.155c-0.022-0.176-0.154-0.33-0.33-0.33s-0.308 0.132-0.33 0.33l-0.506 6.155 0.506 5.958c0 0.198 0.154 0.33 0.33 0.33z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M26.666 17.982l-0.308-14.289c0-0.242-0.132-0.462-0.33-0.594-0.11-0.066-0.242-0.132-0.396-0.132-0.132 0-0.264 0.044-0.396 0.11-0.198 0.132-0.33 0.352-0.33 0.593v0.132l-0.264 14.157 0.264 5.738v0.022c0 0.154 0.066 0.308 0.176 0.418 0.132 0.154 0.33 0.264 0.55 0.264 0.198 0 0.374-0.088 0.506-0.198 0.132-0.132 0.22-0.308 0.22-0.506l0.022-0.572 0.286-5.144z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M9.783 12.245c-0.022-0.22-0.176-0.374-0.374-0.374s-0.374 0.154-0.374 0.374l-0.462 5.716 0.462 6.001c0.022 0.22 0.176 0.374 0.374 0.374s0.374-0.154 0.374-0.374l0.527-6.001-0.527-5.716z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M11.673 8.244c-0.22 0-0.418 0.176-0.418 0.418l-0.44 9.299 0.439 6.001c0.022 0.242 0.198 0.418 0.418 0.418s0.418-0.176 0.418-0.418l0.506-6.001-0.506-9.299c0-0.22-0.198-0.418-0.418-0.418z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M14.399 23.962l0.462-5.979-0.462-11.431c-0.022-0.264-0.22-0.462-0.484-0.462s-0.462 0.198-0.484 0.462l-0.418 11.431 0.418 5.979c0 0.264 0.22 0.462 0.484 0.462 0.264 0.022 0.462-0.198 0.484-0.462z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M28.402 1.737c-0.112-0.069-0.248-0.11-0.394-0.11-0.001 0-0.001 0-0.002 0h0c-0.176 0-0.352 0.066-0.484 0.176-0.176 0.132-0.286 0.352-0.286 0.594v0.088l-0.308 15.52 0.154 2.858 0.154 2.792c0 0.418 0.352 0.747 0.769 0.747s0.747-0.352 0.77-0.769l0.33-5.65-0.33-15.586c-0.022-0.286-0.154-0.528-0.374-0.66z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M0.638 21.258c0.11 0 0.198-0.088 0.22-0.22l0.484-3.078-0.484-3.122c-0.022-0.132-0.11-0.22-0.22-0.22-0.121 0-0.22 0.098-0.22 0.22v0l-0.418 3.122 0.418 3.078c0 0.132 0.11 0.22 0.22 0.22z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M2.726 23.126c0.11 0 0.22-0.088 0.242-0.22l0.638-4.946-0.638-5.056c-0.022-0.132-0.11-0.22-0.242-0.22-0.11 0-0.22 0.088-0.242 0.22l-0.55 5.056 0.55 4.946c0.022 0.132 0.11 0.22 0.242 0.22z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M4.924 24.028c0.154 0 0.264-0.11 0.286-0.286l0.594-5.782-0.594-6.001c-0.022-0.154-0.132-0.286-0.286-0.286s-0.264 0.11-0.286 0.286l-0.527 6.001 0.527 5.782c0.022 0.154 0.132 0.286 0.286 0.286z"></path><path fill="#000" style="fill: var(--color1, #000)" d="M49.352 10.596c-0.945 0-1.846 0.198-2.682 0.528-0.55-6.221-5.782-11.123-12.157-11.123-1.59 0.001-3.109 0.308-4.501 0.864l0.082-0.029c-0.527 0.198-0.659 0.418-0.659 0.813v21.961c0 0.418 0.33 0.747 0.747 0.791h19.191c3.825 0 6.925-3.056 6.925-6.881-0.022-3.825-3.122-6.925-6.947-6.925z"></path><path fill="#f04923" style="fill: var(--color2, #f04923)" d="M5.518 28.578c-0.813-0.198-1.033-0.286-1.033-0.616 0-0.22 0.176-0.462 0.725-0.462 0.462 0 0.835 0.198 1.165 0.527l0.747-0.725c-0.484-0.506-1.077-0.813-1.869-0.813-1.011 0-1.825 0.572-1.825 1.495 0 1.011 0.66 1.319 1.605 1.517 0.967 0.22 1.143 0.374 1.143 0.703 0 0.396-0.286 0.55-0.901 0.55-0.484 0-0.945-0.176-1.319-0.593l-0.747 0.659c0.396 0.572 1.143 0.923 1.978 0.923 1.407 0 2.001-0.659 2.001-1.627 0.044-1.077-0.857-1.363-1.671-1.539zM10.244 26.512c-1.407 0-2.22 1.077-2.22 2.638s0.835 2.638 2.22 2.638c1.385 0 2.22-1.077 2.22-2.638s-0.835-2.638-2.22-2.638zM10.244 30.754c-0.836 0-1.165-0.704-1.165-1.627s0.352-1.626 1.165-1.626c0.835 0 1.165 0.703 1.165 1.626s-0.352 1.627-1.165 1.627zM16.597 29.457c0 0.813-0.396 1.319-1.055 1.319s-1.055-0.527-1.055-1.341v-2.858h-1.033v2.88c0 1.495 0.835 2.33 2.066 2.33 1.297 0 2.067-0.857 2.067-2.33v-2.858h-1.033v2.858h0.044zM22.027 28.754c0 0.286 0.022 0.923 0.022 1.121-0.066-0.132-0.242-0.396-0.352-0.572l-1.825-2.704h-0.989v5.122h1.011v-2.264c0-0.286-0.022-0.923-0.022-1.121 0.066 0.132 0.242 0.395 0.352 0.572l1.869 2.792h0.923v-5.122h-1.011v2.176h0.022zM25.962 26.578h-1.605v5.122h1.517c1.319 0 2.616-0.769 2.616-2.55 0-1.89-1.077-2.572-2.528-2.572zM25.874 30.71h-0.506v-3.121h0.55c1.077 0 1.539 0.527 1.539 1.561 0 0.923-0.506 1.561-1.583 1.561zM31.656 27.523c0.462 0 0.747 0.198 0.945 0.55l0.945-0.44c-0.33-0.659-0.901-1.143-1.869-1.143-1.341 0-2.264 1.077-2.264 2.638 0 1.605 0.901 2.638 2.242 2.638 0.923 0 1.539-0.44 1.891-1.165l-0.857-0.505c-0.264 0.461-0.55 0.659-1.011 0.659-0.769 0-1.209-0.704-1.209-1.627 0-0.945 0.44-1.605 1.187-1.605zM35.459 26.578h-1.033v5.122h3.078v-1.011h-2.044v-4.111zM40.207 26.511c-1.407 0-2.22 1.077-2.22 2.638s0.835 2.638 2.22 2.638c1.407 0 2.22-1.077 2.22-2.638s-0.813-2.638-2.22-2.638zM40.207 30.754c-0.835 0-1.165-0.704-1.165-1.627s0.352-1.626 1.165-1.626c0.836 0 1.165 0.703 1.165 1.626s-0.33 1.627-1.165 1.627zM46.56 29.457c0 0.813-0.396 1.319-1.055 1.319s-1.055-0.527-1.055-1.341v-2.858h-1.033v2.88c0 1.495 0.835 2.33 2.066 2.33 1.297 0 2.066-0.857 2.066-2.33v-2.858h-1.033v2.858h0.044zM50.473 26.577h-1.605v5.122h1.517c1.319 0 2.616-0.769 2.616-2.55 0-1.89-1.077-2.572-2.528-2.572zM50.385 30.71h-0.484v-3.121h0.55c1.077 0 1.517 0.527 1.517 1.561 0 0.923-0.505 1.561-1.583 1.561z"></path></symbol>',
			'spotify'          => '<symbol id="icon-spotify" viewBox="0 0 32 32"><path fill="#1ed760" style="fill: var(--color13, #1ed760)" d="M16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16 16-7.2 16-16-7.12-16-16-16zM23.361 23.12c-0.32 0.479-0.88 0.64-1.361 0.32-3.76-2.32-8.48-2.801-14.081-1.521-0.557 0.163-1.039-0.239-1.199-0.719-0.16-0.561 0.24-1.040 0.72-1.2 6.080-1.361 11.36-0.8 15.52 1.76 0.56 0.24 0.639 0.879 0.401 1.36zM25.281 18.72c-0.401 0.56-1.121 0.8-1.683 0.4-4.319-2.64-10.879-3.44-15.919-1.84-0.639 0.16-1.36-0.16-1.52-0.8s0.16-1.361 0.8-1.521c5.84-1.759 13.040-0.877 18 2.161 0.481 0.241 0.72 1.040 0.321 1.6zM25.441 14.24c-5.121-3.040-13.681-3.36-18.561-1.839-0.8 0.239-1.6-0.241-1.84-0.961-0.24-0.801 0.24-1.6 0.96-1.841 5.68-1.68 15.040-1.36 20.961 2.161 0.719 0.4 0.959 1.36 0.559 2.080-0.399 0.561-1.36 0.799-2.079 0.4z"></path></symbol>',
			'tumblr'           => '<symbol id="icon-tumblr" viewBox="0 0 32 32"><path fill="#36465d" style="fill: var(--color14, #36465d)" d="M19.417 32c-6.791 0-9.375-5.008-9.375-8.548v-10.456h-3.221v-4.132c4.84-1.751 6.016-6.128 6.28-8.625 0.019-0.171 0.153-0.239 0.231-0.239h4.689v8.152h6.401v4.844h-6.427v9.96c0.021 1.335 0.5 3.161 2.943 3.161h0.12c0.841-0.027 1.981-0.273 2.581-0.559l1.541 4.567c-0.581 0.848-3.2 1.832-5.541 1.872h-0.237z"></path></symbol>',
			'twitch'           => '<symbol id="icon-twitch" viewBox="0 0 32 32"><path fill="#6441a4" style="fill: var(--color15, #6441a4)" d="M2.785 0l-2.085 5.567v22.259h7.648v4.175h4.176l4.169-4.176h6.26l8.347-8.344v-19.48zM5.567 2.78h22.953v15.305l-4.869 4.869h-7.651l-4.169 4.169v-4.169h-6.264zM13.22 16.696h2.78v-8.347h-2.78zM20.867 16.696h2.781v-8.347h-2.781z"></path></symbol>',
			'twitter'          => '<symbol id="icon-twitter" viewBox="0 0 32 32"><path fill="#1da1f2" style="fill: var(--color16, #1da1f2)" d="M31.939 6.092c-1.18 0.519-2.44 0.872-3.767 1.033 1.352-0.815 2.392-2.099 2.884-3.631-1.268 0.74-2.673 1.279-4.169 1.579-1.195-1.279-2.897-2.079-4.788-2.079-3.623 0-6.56 2.937-6.56 6.556 0 0.52 0.060 1.020 0.169 1.499-5.453-0.257-10.287-2.876-13.521-6.835-0.569 0.963-0.888 2.081-0.888 3.3 0 2.28 1.16 4.284 2.917 5.461-1.076-0.035-2.088-0.331-2.971-0.821v0.081c0 3.18 2.257 5.832 5.261 6.436-0.551 0.148-1.132 0.228-1.728 0.228-0.419 0-0.82-0.040-1.221-0.115 0.841 2.604 3.26 4.503 6.139 4.556-2.24 1.759-5.079 2.807-8.136 2.807-0.52 0-1.039-0.031-1.56-0.089 2.919 1.859 6.357 2.945 10.076 2.945 12.072 0 18.665-9.995 18.665-18.648 0-0.279 0-0.56-0.020-0.84 1.281-0.919 2.4-2.080 3.28-3.397z"></path></symbol>',
			'vimeo'            => '<symbol id="icon-vimeo" viewBox="0 0 32 32"><path fill="#1ab7ea" style="fill: var(--color17, #1ab7ea)" d="M31.969 8.555c-0.14 3.117-2.319 7.391-6.525 12.812-4.357 5.663-8.035 8.493-11.053 8.493-1.879 0-3.437-1.725-4.737-5.175l-2.557-9.485c-0.959-3.445-1.984-5.171-3.083-5.171-0.239 0-1.075 0.504-2.508 1.509l-1.505-1.943c1.58-1.392 3.135-2.779 4.668-4.171 2.105-1.824 3.687-2.78 4.739-2.879 2.489-0.24 4.021 1.467 4.596 5.117 0.62 3.937 1.052 6.385 1.295 7.343 0.719 3.267 1.508 4.899 2.368 4.899 0.669 0 1.675-1.061 3.020-3.18 1.339-2.119 2.053-3.729 2.149-4.837 0.192-1.828-0.527-2.748-2.152-2.748-0.765 0-1.556 0.161-2.369 0.521 1.581-5.157 4.579-7.676 9.016-7.516 3.297 0.080 4.837 2.219 4.657 6.396z"></path></symbol>',
			'vk'               => '<symbol id="icon-vk" viewBox="0 0 32 32"><path fill="#4680c2" style="fill: var(--color18, #4680c2)" d="M20.912 0h-9.824c-8.965 0-11.088 2.123-11.088 11.088v9.824c0 8.965 2.123 11.088 11.088 11.088h9.824c8.965 0 11.088-2.123 11.088-11.088v-9.824c0-8.965-2.145-11.088-11.088-11.088zM25.835 22.831h-2.325c-0.88 0-1.152-0.7-2.733-2.303-1.377-1.333-1.987-1.513-2.325-1.513-0.475 0-0.611 0.136-0.611 0.791v2.1c0 0.565-0.18 0.904-1.671 0.904-2.461 0-5.195-1.491-7.113-4.269-2.891-4.064-3.683-7.113-3.683-7.745 0-0.339 0.136-0.655 0.791-0.655h2.325c0.587 0 0.813 0.271 1.040 0.903 1.151 3.32 3.071 6.233 3.861 6.233 0.293 0 0.429-0.136 0.429-0.88v-3.435c-0.091-1.581-0.927-1.716-0.927-2.28 0-0.272 0.227-0.543 0.587-0.543h3.659c0.497 0 0.677 0.271 0.677 0.857v4.631c0 0.496 0.227 0.677 0.361 0.677 0.293 0 0.543-0.181 1.084-0.723 1.672-1.875 2.868-4.765 2.868-4.765 0.159-0.339 0.429-0.655 1.017-0.655h2.325c0.7 0 0.859 0.36 0.7 0.857-0.293 1.356-3.139 5.375-3.139 5.375-0.248 0.407-0.339 0.587 0 1.040 0.248 0.339 1.061 1.039 1.604 1.671 0.993 1.129 1.76 2.077 1.964 2.733 0.227 0.653-0.113 0.992-0.767 0.993z"></path></symbol>',
			'wordpress'        => '<symbol id="icon-wordpress" viewBox="0 0 32 32"><path fill="#21759b" style="fill: var(--color19, #21759b)" d="M28.625 9.1c1.12 2.049 1.757 4.4 1.757 6.9 0 5.305-2.875 9.941-7.151 12.433l4.393-12.703c0.82-2.053 1.093-3.695 1.093-5.152 0-0.54-0.035-1.040-0.093-1.48zM17.984 9.239c0.863-0.040 1.643-0.14 1.643-0.14 0.776-0.1 0.685-1.24-0.089-1.199 0 0-2.34 0.18-3.84 0.18-1.419 0-3.8-0.2-3.8-0.2-0.78-0.040-0.881 1.14-0.1 1.18 0 0 0.72 0.081 1.5 0.12l2.24 6.14-3.16 9.44-5.239-15.56c0.865-0.040 1.645-0.133 1.645-0.133 0.78-0.1 0.688-1.24-0.087-1.195 0 0-2.328 0.184-3.832 0.184-0.267 0-0.584-0.011-0.92-0.020 2.603-3.836 7.035-6.416 12.055-6.416 3.745 0 7.153 1.429 9.715 3.777-0.061-0.004-0.121-0.012-0.188-0.012-1.413 0-2.416 1.231-2.416 2.552 0 1.187 0.684 2.191 1.413 3.375 0.548 0.96 1.187 2.191 1.187 3.969 0 1.22-0.472 2.659-1.095 4.639l-1.433 4.78-5.2-15.48zM16 30.379c-1.412 0-2.775-0.204-4.064-0.583l4.316-12.541 4.42 12.116c0.032 0.071 0.067 0.135 0.104 0.199-1.493 0.524-3.1 0.812-4.776 0.812zM1.615 16c0-2.085 0.448-4.067 1.247-5.853l6.859 18.799c-4.795-2.332-8.104-7.251-8.105-12.945zM16 0c-8.82 0-16 7.18-16 16s7.18 16 16 16 16-7.18 16-16-7.18-16-16-16z"></path></symbol>',
			'yelp'             => '<symbol id="icon-yelp" viewBox="0 0 32 32"><path fill="#d32323" style="fill: var(--color20, #d32323)" d="M28.148 24.301c-0.188 1.292-2.825 4.644-4.039 5.129-0.415 0.165-0.815 0.125-1.133-0.12-0.205-0.16-0.419-0.487-3.263-5.103l-0.844-1.376c-0.325-0.493-0.265-1.143 0.139-1.639 0.396-0.479 0.976-0.659 1.481-0.467 0.027 0.016 2.128 0.708 2.128 0.708 4.784 1.572 4.94 1.632 5.143 1.784 0.303 0.248 0.443 0.633 0.38 1.084zM18.56 17.279c-0.339-0.515-0.333-1.121 0.016-1.54l1.331-1.812c2.919-3.979 3.081-4.188 3.279-4.327 0.341-0.228 0.76-0.239 1.161-0.043 1.159 0.563 3.497 4.039 3.639 5.372v0.045c0.039 0.455-0.14 0.824-0.461 1.045-0.219 0.14-0.419 0.221-5.857 1.541-0.86 0.219-1.339 0.339-1.62 0.439l0.039-0.040c-0.539 0.16-1.139-0.099-1.479-0.639zM15.221 15.217c-0.26 0.081-1.052 0.327-2.025-1.251 0 0-6.575-10.345-6.729-10.664-0.093-0.36 0.020-0.765 0.34-1.093 0.979-1.015 6.289-2.5 7.68-2.161 0.453 0.117 0.765 0.401 0.875 0.805 0.080 0.447 0.727 10.048 0.82 12.199 0.088 1.84-0.7 2.087-0.96 2.165zM16.089 25.741c-0.015 5.032-0.025 5.2-0.108 5.439-0.14 0.375-0.461 0.625-0.908 0.707-1.28 0.219-5.289-1.261-6.125-2.253-0.16-0.219-0.26-0.437-0.28-0.657-0.021-0.16 0-0.32 0.060-0.461 0.1-0.26 0.24-0.46 3.84-4.68l1.059-1.259c0.361-0.46 1-0.6 1.599-0.361 0.581 0.22 0.941 0.72 0.901 1.26v2.24zM5.179 22.523c-0.393-0.013-0.747-0.249-0.953-0.64-0.148-0.287-0.252-0.76-0.317-1.336-0.183-1.735 0.039-4.352 0.559-5.183 0.244-0.38 0.6-0.581 0.993-0.568 0.26 0 0.492 0.081 5.639 2.2l1.507 0.599c0.539 0.2 0.872 0.76 0.84 1.401-0.040 0.62-0.397 1.099-0.925 1.24l-2.14 0.68c-4.787 1.54-4.945 1.58-5.197 1.56zM25.148 31.996h-0.005l-0.007 0.004z"></path></symbol>',
			'youtube'          => '<symbol id="icon-youtube" viewBox="0 0 32 32"><path fill="#f00" style="fill: var(--color21, #f00)" d="M31.327 8.273c-0.386-1.353-1.431-2.398-2.756-2.777l-0.028-0.007c-2.493-0.668-12.528-0.668-12.528-0.668s-10.009-0.013-12.528 0.668c-1.353 0.386-2.398 1.431-2.777 2.756l-0.007 0.028c-0.443 2.281-0.696 4.903-0.696 7.585 0 0.054 0 0.109 0 0.163l-0-0.008c-0 0.037-0 0.082-0 0.126 0 2.682 0.253 5.304 0.737 7.845l-0.041-0.26c0.386 1.353 1.431 2.398 2.756 2.777l0.028 0.007c2.491 0.669 12.528 0.669 12.528 0.669s10.008 0 12.528-0.669c1.353-0.386 2.398-1.431 2.777-2.756l0.007-0.028c0.425-2.233 0.668-4.803 0.668-7.429 0-0.099-0-0.198-0.001-0.297l0 0.015c0.001-0.092 0.001-0.201 0.001-0.31 0-2.626-0.243-5.196-0.708-7.687l0.040 0.258zM12.812 20.801v-9.591l8.352 4.803z"></path></symbol>',
		)
	);
}
