(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.reframe = factory());
})(this, (function () { 'use strict';
function reframe(target, cName) {
var _a, _b;
var frames = typeof target === 'string' ? document.querySelectorAll(target) : target;
var c = cName || 'js-reframe';
if (!('length' in frames))
frames = [frames];
for (var i = 0; i < frames.length; i += 1) {
var frame = frames[i];
var hasClass = frame.className.split(' ').indexOf(c) !== -1;
if (hasClass || frame.style.width.indexOf('%') > -1) {
return;
}
var height = frame.getAttribute('height') || frame.offsetHeight;
var width = frame.getAttribute('width') || frame.offsetWidth;
var heightNumber = typeof height === 'string' ? parseInt(height) : height;
var widthNumber = typeof width === 'string' ? parseInt(width) : width;
var padding = (heightNumber / widthNumber) * 100;
var div = document.createElement('div');
div.className = c;
var divStyles = div.style;
divStyles.position = 'relative';
divStyles.width = '100%';
divStyles.paddingTop = "".concat(padding, "%");
var frameStyle = frame.style;
frameStyle.position = 'absolute';
frameStyle.width = '100%';
frameStyle.height = '100%';
frameStyle.left = '0';
frameStyle.top = '0';
(_a = frame.parentNode) === null || _a === void 0 ? void 0 : _a.insertBefore(div, frame);
(_b = frame.parentNode) === null || _b === void 0 ? void 0 : _b.removeChild(frame);
div.appendChild(frame);
}
}
return reframe;
}));