<!DOCTYPE html>
<html <?php language_attributes(); ?> <?php bands_schema_type(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width">
<meta name="twitter:widgets:theme" content="dark">
<meta name="twitter:widgets:link-color" content="#00b4ff">
<meta name="twitter:widgets:border-color" content="#000">
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="wrapper" class="hfeed">
<header id="header"<?php if ( is_front_page() || is_home() || is_front_page() && is_home() || is_singular() ) { ?> style="background-image:url(<?php if ( get_header_image() ) { echo esc_url( get_header_image() ); } else { echo esc_url( get_template_directory_uri() ) . '/images/bg.jpg'; } ?>)"<?php } ?> role="banner">
<div id="header-nav">
<div id="site-title" itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
<?php
if ( is_front_page() || is_home() || is_front_page() && is_home() ) {
echo '<h1>';
}
if ( has_custom_logo() ) {
$custom_logo_id = get_theme_mod( 'custom_logo' );
$logo = wp_get_attachment_image_src( $custom_logo_id , 'full' );
$nologo = '';
} elseif ( has_site_icon() ) {
$logo = get_site_icon_url();
$nologo = '';
} else {
$logo = '';
$nologo = 'no-logo';
}
echo '<a href="' . esc_url( home_url( '/' ) ) . '" title="' . esc_attr( get_bloginfo( 'name' ) ) . '" rel="home" itemprop="url"><span class="screen-reader-text" itemprop="name">' . esc_html( get_bloginfo( 'name' ) ) . '</span><span id="logo-container" itemprop="logo" itemscope itemtype="https://schema.org/ImageObject"><img src="';
if ( has_custom_logo() ) {
echo esc_url( $logo[0] );
} else {
echo esc_url( $logo );
}
echo '" alt="' . esc_attr( get_bloginfo( 'name' ) ) . '" id="logo" class="' . esc_attr( $nologo ) . '" itemprop="url"></span></a>';
if ( is_front_page() || is_home() || is_front_page() && is_home() ) {
echo '</h1>';
}
?>
</div>
<nav id="menu" role="navigation" itemscope itemtype="https://schema.org/SiteNavigationElement">
<button type="button" class="menu-toggle" aria-expanded="false" aria-controls="menu" aria-label="<?php esc_attr_e( 'Toggle navigation menu', 'bands' ); ?>"><span class="menu-icon" aria-hidden="true">&#9776;</span><span class="menu-text screen-reader-text"><?php esc_html_e( 'Menu', 'bands' ); ?></span></button>
<?php wp_nav_menu( array( 'theme_location' => 'main-menu', 'link_before' => '<span itemprop="name">', 'link_after' => '</span>' ) ); ?>
<div id="search"><?php get_search_form(); ?></div>
</nav>
</div>
<?php if ( is_front_page() || is_home() || is_front_page() && is_home() || is_singular() ) { ?><div id="site-description"<?php if ( !is_single() ) { echo ' itemprop="description"'; } ?>><?php echo esc_html( get_bloginfo( 'description' ) ); ?></div><?php } ?>
</header>
<?php echo bands_breadcrumbs(); ?>
<?php if ( is_active_sidebar( 'header-widget-area' ) ) : ?>
<aside id="header-sidebar" role="complementary">
<div id="hsidebar" class="widget-area">
<?php dynamic_sidebar( 'header-widget-area' ); ?>
<div class="clear"></div>
</div>
</aside>
<?php endif; ?>
<div id="container">
<main id="content" role="main">