<?php
add_action( 'customize_register', 'bands_customizer', 20 );
function bands_customizer( $wp_customize ) {
$wp_customize->remove_control( 'blogdescription' );
$wp_customize->remove_control( 'header_textcolor' );
$wp_customize->remove_control( 'display_header_text' );
$sections = array(
'bands_options' => array(
'title' => __( 'Layout & Display', 'bands' ),
'priority' => 20
),
'bands_fonts' => array(
'title' => esc_html__( 'Fonts', 'bands' ),
'priority' => 25
)
);
foreach ( $sections as $section_id => $section_args ) {
$wp_customize->add_section( $section_id, $section_args );
}
$settings = array(
'bands_layout_width' => array(
'default' => '100%',
'sanitize_callback' => 'sanitize_text_field',
'transport' => 'refresh',
'control' => array(
'label' => esc_html__( 'Layout Width', 'bands' ),
'description' => esc_html__( 'Enter any width by % or px (for example, 100% for full width).', 'bands' ),
'section' => 'bands_options',
'type' => 'text'
)
),
'bands_grid_columns' => array(
'default' => '1',
'sanitize_callback' => 'absint',
'transport' => 'refresh',
'control' => array(
'label' => esc_html__( 'Blog Grid Count', 'bands' ),
'section' => 'bands_options',
'type' => 'number'
)
),
'bands_grid_width' => array(
'default' => '300px',
'sanitize_callback' => 'sanitize_text_field',
'transport' => 'refresh',
'control' => array(
'label' => esc_html__( 'Blog Grid Width', 'bands' ),
'description' => esc_html__( 'Enter any width by px only.', 'bands' ),
'section' => 'bands_options',
'type' => 'text'
)
),
'bands_grid_gap' => array(
'default' => '5%',
'sanitize_callback' => 'sanitize_text_field',
'transport' => 'refresh',
'control' => array(
'label' => esc_html__( 'Blog Grid Gap', 'bands' ),
'description' => esc_html__( 'Enter any width by % or px.', 'bands' ),
'section' => 'bands_options',
'type' => 'text'
)
),
'bands_sticky_header' => array(
'default' => '1',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Sticky Header', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_center_logo' => array(
'default' => '',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Center Logo', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_left_logo' => array(
'default' => '',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Left Logo', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_display_sidebar' => array(
'default' => '',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Display Sidebar', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_hide_header' => array(
'default' => '',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Hide Header', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_hide_branding' => array(
'default' => '',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Hide Logo/Site Title', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_hide_menu' => array(
'default' => '',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Hide Menu', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_hide_search' => array(
'default' => '',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Hide Search Form', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_hide_header_image' => array(
'default' => '',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Hide Header Image', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_hide_description' => array(
'default' => '',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Hide Site Description', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_hide_breadcrumbs' => array(
'default' => '1',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Hide Breadcrumbs', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_hide_footer' => array(
'default' => '',
'sanitize_callback' => 'bands_sanitize_checkbox',
'control' => array(
'label' => esc_html__( 'Hide Footer', 'bands' ),
'section' => 'bands_options',
'type' => 'checkbox'
)
),
'bands_header_font' => array(
'default' => '',
'sanitize_callback' => 'sanitize_text_field',
'transport' => 'refresh',
'control' => array(
'label' => esc_html__( 'Headers Font', 'bands' ),
'description' => esc_html__( 'Google Fonts allowed here too.', 'bands' ),
'section' => 'bands_fonts',
'type' => 'text'
)
),
'bands_content_font' => array(
'default' => '',
'sanitize_callback' => 'sanitize_text_field',
'transport' => 'refresh',
'control' => array(
'label' => esc_html__( 'Content Font', 'bands' ),
'description' => esc_html__( 'Google Fonts allowed here too.', 'bands' ),
'section' => 'bands_fonts',
'type' => 'text'
)
),
'bands_accent_color' => array(
'default' => '',
'sanitize_callback' => 'sanitize_hex_color',
'transport' => 'postMessage',
'control' => array(
'label' => esc_html__( 'Accent Color', 'bands' ),
'section' => 'colors',
'type' => 'color',
'priority' => 0
)
),
'bands_header_color' => array(
'default' => '',
'sanitize_callback' => 'sanitize_hex_color',
'transport' => 'postMessage',
'control' => array(
'label' => esc_html__( 'Headers Color', 'bands' ),
'section' => 'colors',
'type' => 'color',
'priority' => 1
)
),
'bands_content_color' => array(
'default' => '',
'sanitize_callback' => 'sanitize_hex_color',
'transport' => 'postMessage',
'control' => array(
'label' => esc_html__( 'Content Color', 'bands' ),
'section' => 'colors',
'type' => 'color',
'priority' => 2
)
),
'bands_link_color' => array(
'default' => '',
'sanitize_callback' => 'sanitize_hex_color',
'transport' => 'postMessage',
'control' => array(
'label' => esc_html__( 'Link Color', 'bands' ),
'section' => 'colors',
'type' => 'color',
'priority' => 3
)
)
);
foreach ( $settings as $setting_id => $setting_args ) {
$wp_customize->add_setting( $setting_id, array(
'default' => $setting_args['default'],
'sanitize_callback' => isset( $setting_args['sanitize_callback'] ) ? $setting_args['sanitize_callback'] : 'sanitize_text_field',
'transport' => isset( $setting_args['transport'] ) ? $setting_args['transport'] : 'refresh'
) );
$control_id = str_replace( 'bands_', '', $setting_id );
$control_args = $setting_args['control'];
$control_args['settings'] = $setting_id;
if ( $control_args['type'] === 'color' ) {
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $control_id, $control_args ) );
} else {
$wp_customize->add_control( new WP_Customize_Control( $wp_customize, $control_id, $control_args ) );
}
}
}
function bands_sanitize_checkbox( $input ) {
if ( $input === true || $input === '1' ) {
return '1';
}
return '';
}
add_action( 'wp_head', 'bands_customizer_css' );
function bands_customizer_css() {
?>
<style>
#container{max-width:<?php echo esc_html( get_theme_mod( 'bands_layout_width' ) ); ?>}
.home #content{column-count:<?php echo esc_html( get_theme_mod( 'bands_grid_columns' ) ); ?>;column-width:<?php echo esc_html( get_theme_mod( 'bands_grid_width' ) ); ?>;column-gap:<?php echo esc_html( get_theme_mod( 'bands_grid_gap' ) ); ?>}
.home .post{break-inside:avoid-column}
#container a, #footer a, ul#breadcrumbs li a, #container h1, #container h2, #container h3, #container h4, #container h5, #container h6, #container h1 a, #container h2 a, #container h3 a, #container h4 a, #container h5 a, #container h6 a, pre, code, #menu .menu-toggle:hover, #menu .menu-toggle:focus{color:<?php echo esc_html( get_theme_mod( 'bands_accent_color' ) ); ?>}
hr, .button, button, input[type="submit"]{background-color:<?php echo esc_html( get_theme_mod( 'bands_accent_color' ) ); ?>}
blockquote, input:focus, #search .search-field:focus, .wp-block-search__input:focus, textarea:focus, #footer .widget .search-field:focus, .sticky, .entry-meta .author-avatar img, #content .gallery img, .box, .box-2, .box-3, .box-4, .box-5, .box-6, .box-1-3, .box-2-3{border-color:<?php echo esc_html( get_theme_mod( 'bands_accent_color' ) ); ?>}
@media(min-width:769px){#menu .current-menu-item a, #menu .current_page_parent a{border-color:<?php echo esc_html( get_theme_mod( 'bands_accent_color' ) ); ?>}}
#container h1, #container h2, #container h3, #container h4, #container h5, #container h6, #container h1 a, #container h2 a, #container h3 a, #container h4 a, #container h5 a, #container h6 a{font-family:<?php echo esc_html( ucwords( str_replace( '+', ' ', get_theme_mod( 'bands_header_font' ) ) ) ); ?>;color:<?php echo esc_html( get_theme_mod( 'bands_header_color' ) ); ?>}
#content p{font-family:<?php echo esc_html( ucwords( str_replace( '+', ' ', get_theme_mod( 'bands_content_font' ) ) ) ); ?>;color:<?php echo esc_html( get_theme_mod( 'bands_content_color' ) ); ?>}
#container a, #footer a, ul#breadcrumbs li a{color:<?php echo esc_html( get_theme_mod( 'bands_link_color' ) ); ?>}
<?php if ( esc_html( get_theme_mod( 'bands_sticky_header' ) ) ) { echo '@media(min-width:769px){#header-nav{position:sticky;top:0;z-index:9999}}'; } ?>
<?php if ( esc_html( get_theme_mod( 'bands_center_logo' ) ) ) { echo '#site-title, #menu{display:block;width:100%;text-align:center;float:none}'; } ?>
<?php if ( esc_html( get_theme_mod( 'bands_left_logo' ) ) ) { echo '#site-title, #menu{display:block;width:100%;text-align:left;float:none}#menu{text-align:center}'; } ?>
<?php if ( esc_html( get_theme_mod( 'bands_display_sidebar' ) ) ) { echo '#content{width:75%;padding:4%;float:left}#sidebar{display:block !important;width:25%;padding:4% 4% 4% 0;float:right}'; } ?>
<?php if ( esc_html( get_theme_mod( 'bands_hide_header' ) ) ) { echo '#header{display:none}'; } ?>
<?php if ( esc_html( get_theme_mod( 'bands_hide_branding' ) ) ) { echo '#site-title{display:none}'; } ?>
<?php if ( esc_html( get_theme_mod( 'bands_hide_menu' ) ) ) { echo '#menu{display:none}'; } ?>
<?php if ( esc_html( get_theme_mod( 'bands_hide_search' ) ) ) { echo '#search{display:none}'; } ?>
<?php if ( esc_html( get_theme_mod( 'bands_hide_header_image' ) ) ) { echo '#header{background-image:none !important}#site-description{padding:10% 5% 5%}'; } ?>
<?php if ( esc_html( get_theme_mod( 'bands_hide_description' ) ) ) { echo '#site-description{display:none}'; } ?>
<?php if ( esc_html( get_theme_mod( 'bands_hide_breadcrumbs' ) ) ) { echo 'ul#breadcrumbs{display:none}'; } ?>
<?php if ( esc_html( get_theme_mod( 'bands_hide_footer' ) ) ) { echo '#footer{display:none}'; } ?>
</style>
<?php
}
add_action( 'customize_preview_init', 'bands_customizer_preview' );
function bands_customizer_preview() {
wp_enqueue_script( 'bands-theme-customizer', get_template_directory_uri() . '/customizer/customizer.js', array( 'jquery', 'customize-preview' ), '', true );
}
add_action( 'customize_preview_init', 'bands_customizer_fonts' );
add_action( 'wp_enqueue_scripts', 'bands_customizer_fonts' );
function bands_customizer_fonts() {
if ( !empty( get_theme_mod( 'bands_header_font' ) ) ) {
wp_enqueue_style( 'bands-header-font', 'https://fonts.googleapis.com/css2?family=' . esc_html( str_replace( ' ', '+', get_theme_mod( 'bands_header_font' ) ) ) . '&display=swap' );
}
if ( !empty( get_theme_mod( 'bands_content_font' ) ) ) {
wp_enqueue_style( 'bands-content-font', 'https://fonts.googleapis.com/css2?family=' . esc_html( str_replace( ' ', '+', get_theme_mod( 'bands_content_font' ) ) ) . '&display=swap' );
}
}
add_action( 'admin_init', 'bands_customizer_styles' );
function bands_customizer_styles() {
wp_enqueue_style( 'bands-customizer-styles', get_template_directory_uri() . '/customizer/customizer.css' );
}