<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package ballyhoo
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( '<h1 class="page-title">', '</h1>' ); ?>
		<p class="page-info"><i class="far fa-clock" aria-hidden="true"></i> <?php echo get_the_date(); ?> <?php if(is_user_logged_in()) : ?> <i class="far fa-edit" aria-hidden="true"></i> <?php edit_post_link(__('Edit Page', 'ballyhoo')); ?><?php endif; ?></p>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<div class="container" style="max-width:100%;">
		<div class="col-sm-7">
		<?php
		the_content();

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'ballyhoo' ),
				'after'  => '</div>',
			)
		);
		?>
	</div><!-- .entry-content -->
	<div class="col-sm-4">
		<?php get_sidebar(); ?>
	</div>
		</div>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->
