<?php
/**
 * The template for displaying Starter Content.
 *
 * @package Ayyash
 * @author ThemeRox
 * @since 2.0.0
 *
 * Template Name: Starter Content
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

do_action( 'ayyash_single_option' );

$ayyash_view = ayyash_get_current_screen();
get_header();

?>
	<div id="content">
		<?php ayyash_title_bar( $ayyash_view ); ?>
		<div <?php ayyash_get_content_class(); ?>>
			<?php ayyash_try_sidebar( $ayyash_view, 'left' ); ?>
			<div id="primary" <?php ayyash_main_class( 'single' ); ?>>
				<main id="main" class="site-main" role="main">
					<?php
					while ( have_posts() ) {
						the_post();
						get_template_part( 'content', 'page' );
					} // end of the loop.
					?>
				</main><!-- #main -->
			</div><!-- #primary -->
		</div><!-- .ayyash-row -->
	</div><!-- #content -->
<?php
get_footer();
