<?php
/**
 * The template for displaying search form.
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

?>
<form class="search" action="<?php echo esc_url( home_url() ); ?>" method="get">
	<fieldset>
		<div class="text">
			<label for="s" class="screen-reader-text"><?php esc_html_e( 'Search', 'ayyash' ); ?></label>
			<input name="s" id="s" type="text" placeholder="<?php esc_attr_e( 'Search ...', 'ayyash' ); ?>"/>
			<button class="ai ai-search"><?php esc_html_e( 'Search', 'ayyash' ); ?></button>
		</div>
	</fieldset>
</form>
