<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined('ABSPATH') ) {
	header('Status: 403 Forbidden');
	header('HTTP/1.1 403 Forbidden');
	die();
}

$ayyash_view   = ayyash_get_current_screen();
$ayyash_layout = ayyash_get_content_layout($ayyash_view);
?>
<div class="ayyash-entry-content format-standard">

	<?php
	if ( has_post_thumbnail() ) {
		?>
		<div class="post-image effect slide-top">
			<?php
			get_template_part('partials/content', 'sticky');
			ayyash_the_post_thumbnail( 'blog-' . $ayyash_layout );
			?>
		</div>
		<?php
	}
	?>

	<div class="post-content-wrap">
		<?php
		if ( ! has_post_thumbnail() ) {
			get_template_part('partials/content', 'sticky');
		}
		ayyash_show_taxonomy();
		ayyash_show_entry_header();
		ayyash_show_entry_content();
		ayyash_show_entry_meta();
		ayyash_show_entry_footer();
		?>
	</div><!-- .post-content-wrap -->
</div><!-- .ayyash-entry-content -->
