<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

$ayyash_view   = ayyash_get_current_screen();
$ayyash_layout = ayyash_get_content_layout( $ayyash_view );
$ayyash_link   = get_post_meta( $post->ID, 'ayyash_link_url', true );
?>

<div class="ayyash-entry-content format-link">
	<?php ayyash_post_format_get_post_link( $ayyash_layout ); ?>

	<div class="post-content-wrap">
		<?php
		if ( ! empty( $ayyash_link ) || ! has_block( 'core/paragraph', get_the_content() ) ) {
			get_template_part( 'partials/content', 'sticky' );
		}
		ayyash_show_taxonomy();
		ayyash_show_entry_header();
		ayyash_show_entry_content();
		ayyash_show_entry_meta();
		ayyash_show_entry_footer();
		?>
	</div><!-- .post-content-wrap -->
</div><!-- .ayyash-entry-content -->
