<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

$ayyash_view   = ayyash_get_current_screen();
$ayyash_layout = ayyash_get_content_layout( $ayyash_view );
$image         = get_media_embedded_in_content( apply_filters( 'the_content', get_the_content() ), array( 'image' ) );

if ( is_single() ) {
	get_template_part( 'post-format/entry-content' );
}
?>
<div class="ayyash-entry-content format-image">
	<?php ayyash_post_format_get_post_image( $ayyash_layout ); ?>

	<div class="post-content-wrap">
		<?php
		if ( ! has_post_thumbnail() && ! has_block('core/image', get_the_content() ) && empty( $image ) ) {
			get_template_part( 'partials/content', 'sticky' );
		}
		ayyash_show_taxonomy();
		ayyash_show_entry_header();
		ayyash_show_entry_content();
		ayyash_show_entry_meta();
		ayyash_show_entry_footer();
		?>
	</div><!-- .post-content-wrap -->
</div><!-- .ayyash-entry-content -->
