<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

$ayyash_view   = ayyash_get_current_screen();
$ayyash_layout = ayyash_get_content_layout( $ayyash_view );
$gallery       = get_post_meta( get_the_ID(), 'ayyash_gallery', true );
$post_gallery  = get_post_gallery( get_the_ID(), false );
?>
<div class="ayyash-entry-content format-gallery">
	<?php ayyash_post_format_get_post_gallery( get_the_ID(), $ayyash_layout ); // @phpstan-ignore-line ?>

	<div class="post-content-wrap">
		<?php
		if ( ! $gallery && ! has_block('core/gallery', get_the_content() ) && empty( $post_gallery ) ) {
			get_template_part( 'partials/content', 'sticky' );
		}
		ayyash_show_taxonomy();
		ayyash_show_entry_header();
		ayyash_show_entry_content();
		ayyash_show_entry_meta();
		ayyash_show_entry_footer();
		?>
	</div><!-- .post-content-wrap -->
</div><!-- .ayyash-entry-content -->
