<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

$ayyash_view = ayyash_get_current_screen();
?>

<div id="content">
	<?php ayyash_title_bar( $ayyash_view ); ?>

	<?php get_template_part( 'partials/content', 'featured' ); ?>

	<div <?php ayyash_get_content_class(); ?>>
		<div class="<?php echo esc_attr( apply_filters( 'ayyash_content_container_class', ayyash_get_mod( 'layout_global_content_layout' ) ) ); ?>">
			<div class="row">

				<?php ayyash_try_sidebar( $ayyash_view, 'left' ); ?>

				<div id="primary" <?php ayyash_main_class(); ?>>
					<?php
					if ( is_author() ) {
						ayyash_post_author_info();
					}
					?>
					<main id="main" class="site-main" role="main">

						<?php if ( have_posts() ) : ?>
							<?php get_template_part( 'partials/content', 'loop' ); ?>
							<?php ayyash_pagination(); ?>
						<?php else : ?>
							<?php get_template_part( 'content', 'none' ); ?>

						<?php endif; ?>

					</main>
					<!-- #main -->
				</div>
				<!-- #primary -->

				<?php ayyash_try_sidebar( $ayyash_view, 'right' ); ?>

			</div>
			<!-- .row -->
		</div>
		<!-- .container -->
	</div>
	<!-- .ayyash-row -->
</div><!-- #content -->
