<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

$ayyash_view   = ayyash_get_current_screen();
$ayyash_layout = ayyash_get_content_layout( $ayyash_view );

do_action( 'ayyash_before_content_loop', $ayyash_layout, $ayyash_view );

/* Start the Loop */
while ( have_posts() ) {
	the_post();

	$format = get_post_format();
	$format = $format ? $format : 'standard';

	do_action( 'ayyash_before_content_loop_layout', $ayyash_layout, $ayyash_view, $format );

	?>
	<article <?php post_class( 'ayyash-post' ); ?> id="post-<?php the_ID(); ?>">
		<?php get_template_part( 'post-format/content', $format ); ?>
	</article><!-- #post-## -->
	<?php

	do_action( 'ayyash_after_content_loop_layout', $ayyash_layout, $ayyash_view, $format );
}

do_action( 'ayyash_after_content_loop', $ayyash_layout, $ayyash_view );
