<?php
/**
 * The template for displaying all pages.
 *
 * @package Ayyash
 * @author ThemeRox
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

do_action( 'ayyash_single_option' );

$ayyash_view = ayyash_get_current_screen();
get_header();

?>
	<div id="content">
		<?php ayyash_title_bar( $ayyash_view ); ?>
		<div <?php ayyash_get_content_class(); ?>>
			<div class="<?php echo esc_attr( apply_filters( 'ayyash_content_container_class', ayyash_get_mod( 'layout_global_content_layout' ) ) ); ?>">
				<div class="row">
					<?php ayyash_try_sidebar( $ayyash_view, 'left' ); ?>
					<div id="primary" <?php ayyash_main_class( 'single' ); ?>>
						<main id="main" class="site-main" role="main">
							<?php
							while ( have_posts() ) {
								the_post();
								get_template_part( 'content', 'page' );
								// If comments are open or we have at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) {
									comments_template();
								}
							} // end of the loop.
							?>
						</main><!-- #main -->
					</div><!-- #primary -->
					<?php ayyash_try_sidebar( $ayyash_view, 'right' ); ?>
				</div><!-- .row -->
			</div><!-- .container -->
		</div><!-- .ayyash-row -->
	</div><!-- #content -->
<?php
get_footer();
